package com.qiho.manager.biz.params.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.qiho.manager.common.param.PageParam;

/**
 * 用户评价分页参数
 *
 * @author peanut.huang
 * @date 2018/6/6.
 */
@ApiModel("用户评价分页参数")
public class EvaluatePagingParams extends PageParam {

    @ApiModelProperty("订单id")
    private String orderId;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("评分")
    private Integer rating;

    @ApiModelProperty("商家id")
    private Long merchantId;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("查询开始时间")
    private String startTime;

    @ApiModelProperty("查询结束时间")
    private String endTime;


    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public Integer getRating() {
        return rating;
    }

    public void setRating(Integer rating) {
        this.rating = rating;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }
}
