package com.qiho.manager.biz.runnable;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ServletContextAware;

import javax.annotation.Resource;
import javax.servlet.ServletContext;
import java.io.File;
import java.util.Map;

/**
 * Created by danke on 2017/8/22.
 */
@Component
@Scope("prototype")
public class BaseExportRunnable implements ServletContextAware {

    private ServletContext servletContext;

    protected Joiner joiner           = Joiner.on(",").useForNull("");

    @Resource(name = "stringRedisTemplate")
    protected StringRedisTemplate redisTemplate;

    protected static final String SEPARATOR = "/";

    protected Map<String, Object> init(File file,Long taskId) {
        return this.init(file,taskId,CacheConstantseEnum.EXPORT_ORDER);
    }

    protected Map<String, Object> init(File file,Long taskId,CacheConstantseEnum constantseEnum) {
        String key = constantseEnum.getCacheKey(taskId);
        redisTemplate.opsForHash().put(key, "successCount", "0");
        redisTemplate.opsForHash().put(key, "success", "false");
        redisTemplate.opsForHash().put(key, "url", "");
        redisTemplate.opsForHash().put(key, "message", "导出中");

        Map<String, Object> info = Maps.newHashMap();
        info.put("taskId", taskId.toString());
        info.put("fileName", file.getName());
        return info;
    }

    protected File getFile(String filePath){
        String webRootDir = servletContext.getRealPath(SEPARATOR);
        File userDir = new File(webRootDir, SEPARATOR+filePath);
        if (!userDir.exists()) {
            userDir.mkdirs();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(System.currentTimeMillis()).append(".csv");
        return new File(userDir, sb.toString());
    }

    protected File getFile2(String filePath){
        String webRootDir = servletContext.getRealPath(SEPARATOR);
        File userDir = new File(webRootDir, SEPARATOR+filePath);
        if (!userDir.exists()) {
            userDir.mkdirs();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(System.currentTimeMillis()).append(".xlsx");
        return new File(userDir, sb.toString());
    }

    protected String useForNull(Object obj) {
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        if (Objects.equal(null, obj)) {
            builder.append("");
        } else {
            builder.append(obj.toString());
        }
        builder.append("\"");
        return builder.toString();
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}
