package com.qiho.manager.biz.runnable;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.enums.ErpManufacturerType;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.params.ErpOrderPageParams;
import com.qiho.center.api.remoteservice.order.RemoteErpOrderService;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.util.AppLogUtil;
import com.qiho.manager.common.util.UploadTool;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.stereotype.Component;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by weny.cai on 2017/11/17.
 */
@Component
@Scope("prototype")
@Deprecated
public class WdtErpOrderExportRunnable extends BaseExportRunnable implements Runnable{

    private static final Logger LOGGER = LoggerFactory.getLogger(WdtErpOrderExportRunnable.class);

    private static final int ORDER_EXPORT_MAX = 1000;

    @Autowired
    private RemoteErpOrderService remoteErpOrderService;

    private ErpOrderPageParams params;

    private String[] wdtColnums = {"原始单号","商家编码","货品数量","网名","收件人","手机","省","市","区",
            "地址","应收合计","货品总价","店铺名称","订单类型","发货方式"};

    private String[] edbColnums = {"订单号","产品条码","订单状态","买家id","子订单编号","买家昵称","商品名称","产品规格","商品单价",
            "商品数量","商品总价","运费","购买优惠信息","总金额","买家购买附言","收货人姓名","收货地址-省市","收货地址-街道地址","邮编","收货人手机","收货人电话","买家选择运送方式",
            "卖家备忘内容","订单创建时间","付款时间","物流公司","物流单号","发货附言","发票抬头","电子邮件"};

    private File file;

    private String filePath = "orders/";

    private Long taskId = new Date().getTime();

    private static final String DIRECTLY_CITY = "市";

    /**
     * 初始化
     * @return 任务号
     */
    public Map<String,Object> init(){
        file = super.getFile(filePath);
        return super.init(file,taskId);
    }

    @Override
    public void run() {
        CharSink charSink = Files.asCharSink(file, Charset.forName("GBK"), FileWriteMode.APPEND);
        DubboResult<Integer> exportCount = remoteErpOrderService.findErpOrderPageCount(params);
        int batch = getBatchs(exportCount.getResult());
        List<String> headers = Lists.newArrayList();
        Function<OrderSnapshotDto,String> trsform = null;
        if(ErpManufacturerType.EDB.getCode().equals(params.getErpType())){
            trsform = new WdtErpOrderExportRunnable.EdbOrderSnapshotToString();
            headers.add(joiner.join(edbColnums));
        }else{
            trsform = new WdtErpOrderExportRunnable.OrderSnapshotToString();
            headers.add(joiner.join(wdtColnums));
        }

        CacheConstantseEnum constantseEnum = CacheConstantseEnum.EXPORT_ORDER;
        String key = constantseEnum.getCacheKey(taskId);
        HashOperations<String,String,Object> operations = redisTemplate.opsForHash();
        try{
            charSink.writeLines(headers);
            for(int i=0;i<batch;i++){
                params.setOffset(i*ORDER_EXPORT_MAX);
                DubboResult<List<OrderSnapshotDto>> result = remoteErpOrderService.findWdtExportErpOrder(params);
                List<String> list = Lists.transform(result.getResult(),trsform);
                charSink.writeLines(list);
                operations.increment(key,"successCount",list.size());
            }

            operations.put(key,"message","文件上传中");
            String url = UploadTool.uploadOssNotCDN(file,filePath+file.getName(),"application/csv;charset=GBK");

            operations.put(key,"url",url);
            operations.put(key,"message","导出成功");
        } catch (Exception e) {
            AppLogUtil.error(LOGGER,"orders Export error msg={}",e);
            operations.put(key, "message", e.getMessage());
        } finally {
            operations.put(key, "success", "true");
            if (file != null && file.exists() && !file.delete()) {
                AppLogUtil.warn(LOGGER,
                        "file delete error or file not exists");
            }
        }
    }

    private class EdbOrderSnapshotToString implements Function<OrderSnapshotDto,String> {

        @Override
        public String apply(OrderSnapshotDto input) {
            List<String> row = Lists.newArrayList();
            row.add(useForNull(input.getErpId()));
            row.add(useForNull(input.getSkuNo()));
            if(PayTypeEnum.COD.getCode().equals(input.getPayType())){
                row.add("货到付款");
            }else {
                row.add("买家已付款，等待卖家发货");
            }
            row.add(useForNull(input.getConsumerName()));
            row.add(useForNull(input.getErpId()));
            row.add(useForNull(input.getConsumerName()));
            row.add(useForNull(input.getItemName()));
            row.add(useForNull(null));
            row.add(useForNull(input.getSellingPrice()));
            row.add(useForNull(input.getQuantity()));
            row.add(useForNull(input.getOrderAmt()));
            row.add(useForNull(null));
            row.add(useForNull(null));
            row.add(useForNull(input.getOrderAmt()));
            row.add(useForNull(input.getMessage()));
            row.add(useForNull(input.getConsumerName()));
            if(input.getProvince().indexOf(DIRECTLY_CITY)>-1){
                if(StringUtils.isNotBlank(input.getDistrict())){
                    row.add(useForNull(input.getCity()+input.getDistrict()));
                }else{
                    row.add(useForNull(input.getProvince()+input.getCity()));
                }
            }else {
                row.add(useForNull(input.getProvince()+input.getCity()+input.getDistrict()));
            }
            row.add(useForNull(input.getAddress()));
            row.add(useForNull(null));
            row.add(useForNull(input.getMobile()));
            row.add(useForNull(null));
            row.add(useForNull(null));
            row.add(useForNull(null));
            row.add(useForNull(DateUtils.getSecondStr(input.getGmtCreate())));
            if(PayTypeEnum.COD.getCode().equals(input.getPayType())){
                row.add(useForNull(null));
            }else {
                row.add(useForNull(DateUtils.getSecondStr(input.getGmtModified())));
            }
            row.add(useForNull(null));
            row.add(useForNull(null));
            row.add(useForNull(null));
            row.add(useForNull(null));
            row.add(useForNull(null));
            return joiner.join(row);
        }

    }


    private class OrderSnapshotToString implements Function<OrderSnapshotDto,String> {

        @Override
        public String apply(OrderSnapshotDto input) {
            List<String> row = Lists.newArrayList();
            row.add(useForNull(input.getErpId()));
            row.add(useForNull(input.getSkuNo()));
            row.add(useForNull(input.getQuantity()));
            row.add(useForNull(input.getConsumerName()));
            row.add(useForNull(input.getConsumerName()));
            row.add(useForNull(input.getMobile()));
            row.add(useForNull(input.getProvince()));
            row.add(useForNull(input.getCity()));
            row.add(useForNull(input.getDistrict()));
            row.add(useForNull(input.getAddress()));
            row.add(useForNull(input.getOrderAmt()/100.0));
            row.add(useForNull(input.getOrderAmt()/100.0));
            row.add(useForNull("奇货"));
            if(PayTypeEnum.COD.getCode().equals(input.getPayType())){
                row.add("货到付款");
                row.add("货到付款");
            }else {
                row.add("款到发货");
                row.add("款到发货");
            }
            return joiner.join(row);
        }

    }

    private int getBatchs(int total){
        return total%ORDER_EXPORT_MAX==0?total/ORDER_EXPORT_MAX:(total/ORDER_EXPORT_MAX+1);
    }

    public ErpOrderPageParams getParams() {
        return params;
    }

    public void setParams(ErpOrderPageParams params) {
        params.setMax(ORDER_EXPORT_MAX);
        params.setOffset(0);
        this.params = params;
    }
}
