package com.qiho.manager.biz.runnable.ordertaskhandler;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.qiho.center.api.dto.ExpressBlackListDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.ExpressBlackListPageParams;
import com.qiho.center.api.remoteservice.RemoteExpressBlackListService;
import com.qiho.manager.biz.runnable.BaseExportRunnable;
import com.qiho.manager.biz.service.ExpressBlackService;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.util.AppLogUtil;
import com.qiho.manager.common.util.UploadTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.stereotype.Component;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by qianjue on 2017/7/19.
 */
@Component
@Scope("prototype")
public class ExpressBlackListExportRunnable extends BaseExportRunnable implements  Runnable {

	private static final Logger LOGGER = LoggerFactory.getLogger(ExpressBlackListExportRunnable.class);

	private ExpressBlackListPageParams  params;

	@Autowired
	private ExpressBlackService expressBlackListService;

    @Autowired
	private RemoteExpressBlackListService  remoteExpressBlackListService;

	private Long  taskId  =  new Date().getTime();

	private String filePath = "expressBlackList/";

	private  File  file;

	private static final int  BATCH_NUM = 1000;

	private String[] headersColumn = {"行政区域代码","类型","添加时间"};

	public ExpressBlackListPageParams getParams() {
		return params;
	}

	public void setParams(ExpressBlackListPageParams params) {
		params.setMax(Integer.MAX_VALUE);
		params.setOffset(0);
		this.params = params;
	}

	@Override 
	public void run() {
		CharSink charSink = Files.asCharSink(file, Charset.forName("GBK"), FileWriteMode.APPEND);
		int count = expressBlackListService.queryExpressBlackListNum(params);
		int batch = getBatchs(count);
		CacheConstantseEnum constantseEnum = CacheConstantseEnum.EXPORT_EXPRESS_BLACK_LIST;
		String key = constantseEnum.getCacheKey(taskId);
		HashOperations<String,String,Object> operations = redisTemplate.opsForHash();

		try{
			//封装csv文件的head信息
			List<String> headers = Lists.newArrayList(joiner.join(headersColumn));
			charSink.writeLines(headers);
			//循环分批次查询数据写入csv文件
			OrderSnapshotToString transform = new OrderSnapshotToString();
			for(int i = 0;i < batch; i++ ){
				params.setOffset(i * BATCH_NUM);
				DubboResult<PagenationDto<ExpressBlackListDto>> result = remoteExpressBlackListService.findExpressBlackPage(params);
				List<String> list = Lists.transform(result.getResult().getList(),transform);
				charSink.writeLines(list);
				operations.increment(key,"successCount",list.size());
			}
			operations.put(key,"message","文件上传中");
			String url = UploadTool.uploadOssNotCDN(file,filePath+file.getName(),"application/csv;charset=GBK");
			operations.put(key,"url",url);
			operations.put(key,"message","导出成功");
		} catch (Exception e) {
			AppLogUtil.error(LOGGER,"black Export error msg={}",e);
			operations.put(key, "message", e.getMessage());
		} finally {
			operations.put(key, "success", "true");
			if (file != null && file.exists() && !file.delete()) {
				AppLogUtil.warn(LOGGER,"file delete error or file not exists");
			}
		}
	}

	private int getBatchs(int count) {
		return count %  BATCH_NUM == 0 ? count / BATCH_NUM : count / BATCH_NUM + 1;
	}


	public Map<String,Object> init() {
		file = super.getFile(filePath);
		return super.init(file,taskId,CacheConstantseEnum.EXPORT_EXPRESS_BLACK_LIST);
	}

	private class OrderSnapshotToString implements Function<ExpressBlackListDto, String> {

		@Override
		public String apply(ExpressBlackListDto input) {
			List<String> row = Lists.newArrayList();
			row.add(useForNull(input.getAddressCode()));
			row.add(useForNull(input.getExpressCompany().getName()));
			row.add(useForNull(DateUtils.getSecondStr(input.getGmtCreate())));
			return joiner.join(row);
		}
	}
}
