package com.qiho.manager.biz.service;

import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.advert.ItemCostVO;
import com.qiho.manager.biz.vo.advert.ItemPlanVO;
import com.qiho.manager.biz.vo.advert.TuiaPlanVO;

import java.util.Date;
import java.util.List;

/** 商品广告计划服务接口
 * @author chensong
 * @create 2018-01-10 09:37
 **/
public interface ItemPlanService {

    /**
     * 商品广告计划分页查询
     * @return
     */
    Pagenation<ItemPlanVO> queryList(Long itemId, String itemName, Integer pageNum, Integer pageSize);

    /**
     * 获取广告计划
     * @param itemId
     * @return
     */
    List<TuiaPlanVO> findPlan(Long itemId);

    /**
     * 绑定广告计划
     * @param itemId
     * @param planList
     * @return
     */
    Boolean bindPlan(Long itemId, List<Long> planList);

    /**
     * 分页查询商品消耗数据
     * @param itemid
     * @param itemName
     * @param startTime
     * @param endTime
     * @param pageNum
     * @param pageSize
     * @return
     */
    Pagenation<ItemCostVO> queryData(Long itemid, String itemName, Date startTime, Date endTime, Integer pageNum, Integer pageSize);





}
