package com.qiho.manager.biz.service.account;

import com.qiho.center.api.params.account.AccountPageParam;
import com.qiho.manager.biz.params.MainAccountParam;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.account.IdAndNameVO;
import com.qiho.manager.biz.vo.account.MainAccountVO;

import java.util.List;

/**
 * 主账号操作
 * <p>
 * Created by sunchangji on 2017/12/11.
 */
public interface BaiqiAccountService {

    /**
     * 分页查询主账号列表信息
     *
     * @param pageQueryParams
     * @return
     */
    Pagenation<MainAccountVO> findPageAccount(AccountPageParam pageQueryParams);

    /**
     * 新增账号
     *
     * @param mainAccountParam
     * @return
     */
    String inserAccount(MainAccountParam mainAccountParam);

    /**
     * 更新账号信息
     *
     * @param id
     * @param mobile
     * @param pwd
     * @return
     */
    String updateAccount(Long id, String mobile, String pwd);

    /**
     * 启用禁用账号
     *
     * @param id
     * @param state
     * @return
     */
    String changeAccountState(Long id, boolean state);

    /**
     * 根据账户类型查询排除关联过的商家列表或代理商列表数据
     *
     * @param accountType 0为主账户,2为代理商
     * @return
     */
    List<IdAndNameVO> findRelationIdAndName(int accountType);


}
