package com.qiho.manager.biz.service.finance.impl;



import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.BaseResultDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.account.BaiqiFinanceRechargeDetailDto;
import com.qiho.center.api.dto.account.BaiqiFinanceRechargeDto;
import com.qiho.center.api.enums.finance.BaiqiFinanceRechargeStateEnum;
import com.qiho.center.api.params.finance.BaiqiFinanceRechargeQryParam;
import com.qiho.center.api.remoteservice.finance.RemoteBaiqiFinanceRechargeBackendService;
import com.qiho.manager.biz.params.finance.FinanceRechargeParam;
import com.qiho.manager.biz.service.finance.BaiqiFinanceRechargeService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.finance.FinanceRechargeInfoVO;
import com.qiho.manager.common.util.BigDecimalUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 账户充值服务
 * Author: zhanghuifeng
 * Date:   13:59 2017/12/22
 */
@Service("baiqiFinanceRechargeService")
public class BaiqiFinanceRechargeServiceImpl implements BaiqiFinanceRechargeService {

    @Resource
    private RemoteBaiqiFinanceRechargeBackendService remoteBaiqiFinanceRechargeBackendService;

    @Override
    public Pagenation<FinanceRechargeInfoVO> findPage(BaiqiFinanceRechargeQryParam queryParams) {
        Pagenation<FinanceRechargeInfoVO> page = new Pagenation<>();
        PagenationDto<BaiqiFinanceRechargeDetailDto> result = remoteBaiqiFinanceRechargeBackendService.find4Page(queryParams);
        page.setTotal(result.getTotal());
        // 校验是否有返回数据
        if (result.getTotal() == 0) {
            page.setList(Lists.newArrayList());
            return page;
        }
        page.setList(mergeVo(result.getList()));
        return page;
    }

    private List<FinanceRechargeInfoVO> mergeVo(List<BaiqiFinanceRechargeDetailDto> list){
        List<FinanceRechargeInfoVO> vos = new ArrayList<>();
        for (BaiqiFinanceRechargeDetailDto dto : list){
            FinanceRechargeInfoVO vo = new FinanceRechargeInfoVO();
            vo.setStateValue(BaiqiFinanceRechargeStateEnum.getByState(dto.getState()).getDesc());
            vo.setState(dto.getState());
            vo.setCashSum(BigDecimalUtil.integerToMove2PointLeft(dto.getCashSum()));
            vo.setCommercialTenantId(dto.getCommercialTenantId());
            vo.setCommercialTenantName(dto.getCommercialTenantName());
            vo.setCreator(dto.getCreator());
            vo.setGmtCreate(dto.getGmtCreate());
            vo.setRebateSum(BigDecimalUtil.integerToMove2PointLeft(dto.getRebateSum()));
            vo.setRechargeNo(dto.getRechargeNo());
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public Boolean submit(FinanceRechargeParam rechargeParam) {
        BaiqiFinanceRechargeDto dto = BeanUtils.copy(rechargeParam, BaiqiFinanceRechargeDto.class);
        String name = RequestTool.getAdmin().getName();
        dto.setCreator(name);
        dto.setOperator(name);
        dto.setState(BaiqiFinanceRechargeStateEnum.WAIT_AID.getState());
        return remoteBaiqiFinanceRechargeBackendService.rechargeSubmit(dto);
    }

    @Override
    public BaseResultDto audit(Long rechargeNo, Integer state) {
        return remoteBaiqiFinanceRechargeBackendService.audit(rechargeNo,state, RequestTool.getAdmin().getName());
    }

    @Override
    public BaiqiFinanceRechargeDetailDto find(Long rechargeNo) {
        return remoteBaiqiFinanceRechargeBackendService.findByNo(rechargeNo);
    }
}
