package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.qiho.center.api.dto.*;
import com.qiho.center.api.enums.*;
import com.qiho.center.api.params.AfterSaleQueryParams;
import com.qiho.center.api.remoteservice.order.RemoteAfterSaleOrderService;
import com.qiho.center.api.remoteservice.order.RemoteFundOrderService;
import com.qiho.center.api.remoteservice.order.RemoteOrderService;
import com.qiho.manager.biz.service.AfterSaleOrderService;
import com.qiho.manager.biz.vo.AfterSaleVO;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.common.exception.QihoManagerException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * Created by danke on 2017/10/13.
 */
@Service
public class AfterSaleOrderServiceImpl implements AfterSaleOrderService {

    @Resource
    private RemoteAfterSaleOrderService afterSaleOrderService;

    @Resource
    private RemoteOrderService remoteOrderService;

    @Resource
    private RemoteFundOrderService remoteFundOrderService;

    @Override
    public String saveAfterSale(AfterSaleOrderDto param) {
        //校验参数
        if (!checkParam(param))
            throw new QihoManagerException("退款金额大于可退款总金额");
        return afterSaleOrderService.save(param);
    }

    @Override
    public Pagenation<AfterSaleVO> queryAfterSale(AfterSaleQueryParams queryParams) {
        PagenationDto<AfterSaleOrderDto> resultBase = afterSaleOrderService.queryAfterSaleByQuery(queryParams);
        Pagenation pagenation = new Pagenation();
        pagenation.setTotal(resultBase.getTotal());
        List<AfterSaleOrderDto> afterSaleOrderDtoList = resultBase.getList();
        if (CollectionUtils.isNotEmpty(afterSaleOrderDtoList)){
            List<String> orderIds = afterSaleOrderDtoList.stream().map(AfterSaleOrderDto::getOrderId).collect(Collectors.toList());
            List<OrderSnapshotDto> snapshotDtos = remoteOrderService.queryOrderByOrderIds(orderIds);
            List<AfterSaleVO> afterSaleVOS = afterSaleOrderDtoList.stream().map(e -> dtoToVo(e,snapshotDtos))
                    .collect(Collectors.toList());
            pagenation.setList(afterSaleVOS);
        }
        return pagenation;
    }

    @Override
    public Boolean updateAfterSale(AfterSaleOrderDto param) {
        AfterSaleStageDto afterSaleStageDto = new AfterSaleStageDto();
        afterSaleStageDto.setUpdateTime(DateUtils.getSecondStr(new Date()));
        switch (AfterSaleOrderStatusEnum.getByCode(param.getAfterSaleStatus())){//记录时间节点操作
            case AFTER_SALEING://确认售后
                afterSaleStageDto.setType(AfterSaleOrderStageEnum.ITEM_RECEIVE.getCode());
                break;
            case SUCCESS://售后完成
                afterSaleStageDto.setType(AfterSaleOrderStageEnum.REFUND_SUCCESS.getCode());
                break;
            case CANCLE://取消售后
                afterSaleStageDto.setType(AfterSaleOrderStageEnum.CANCEL.getCode());
                break;
            default:
                break;
        }
        param.setDetailStage(Stream.of(afterSaleStageDto).collect(Collectors.toList()));
        return afterSaleOrderService.updateAfterSaleByDto(param);
    }

    /**
     * 将dto转换为前段展示的vo
     */
    private AfterSaleVO dtoToVo(AfterSaleOrderDto dto,List<OrderSnapshotDto> snapshotDtos){
        AfterSaleVO afterSaleVO = BeanUtils.copy(dto,AfterSaleVO.class);
        afterSaleVO.setAfterSaleReason(AfterSaleOrderReasonEnum.getByCode(dto.getAfterSaleReason()).getMsg());
        afterSaleVO.setAfterSaleStatus(AfterSaleOrderStatusEnum.getByCode(dto.getAfterSaleStatus()).getMsg());
        afterSaleVO.setAfterSaleType(AfterSaleOrderTypeEnum.getByCode(dto.getAfterSaleType()).getDesc());
        afterSaleVO.setGmtCreate(DateUtils.getSecondStr(dto.getGmtCreate()));
        afterSaleVO.setGmtModified(DateUtils.getSecondStr(dto.getGmtModified()));
        afterSaleVO.setFreightAmt(dto.getRefreightAmt());
        for (OrderSnapshotDto orderSnapshotDto :snapshotDtos){
            if (afterSaleVO.getOrderId().equals(orderSnapshotDto.getOrderId())){
                afterSaleVO.setOrderGmtModified(DateUtils.getSecondStr(orderSnapshotDto.getGmtCreate()));
                break;
            }
        }
        return afterSaleVO;
    }


    /**
     * 校验售后订单保存参数,ture = 校验通过
     */
    private Boolean checkParam(AfterSaleOrderDto param){
        String orderId = param.getOrderId();
        DubboResult<OrderDto> result = remoteOrderService.findByOrderId(orderId);
        if (!result.isSuccess() || null == result.getResult())
            throw new QihoManagerException("主订单不存在");
        OrderDto orderDto = result.getResult();
        Integer countAmt = orderDto.getOrderAmt();
        Integer alreadRefund = 0;
        List<AfterSaleOrderDto> afterSaleOrderDtos = afterSaleOrderService.queryAfterSaleByOrderId(orderId);
        if (CollectionUtils.isNotEmpty(afterSaleOrderDtos)){
            //判断手否有正在进行中的售后子订单
            for (AfterSaleOrderDto afterSaleOrderDto : afterSaleOrderDtos){
                AfterSaleOrderStatusEnum statusEnum = AfterSaleOrderStatusEnum.getByCode(afterSaleOrderDto.getAfterSaleStatus());
                if (statusEnum != AfterSaleOrderStatusEnum.SUCCESS && statusEnum != AfterSaleOrderStatusEnum.CANCLE){
                    throw new QihoManagerException("已经存在发的售后,不能再次发起");
                }
            }
            //查询对应的退款子订单,计算退款金额
            alreadRefund += checkAmt(orderId);
        }
        if (countAmt >= (alreadRefund + param.getRefundAmt()))
            return Boolean.TRUE;
        return Boolean.FALSE;
    }

    private Integer checkAmt(String orderId){
        Integer baseAmt = 0;
        DubboResult<List<FundOrderDto>> dubboResult = remoteFundOrderService.findByOrderIdAndBizType(orderId,FundBizTypeEnum.REFUND.getCode());
        if (null != dubboResult && dubboResult.isSuccess() && CollectionUtils.isNotEmpty(dubboResult.getResult())){
            List<FundOrderDto> fundOrderDtos = dubboResult.getResult();
            //过滤出退款成功的资金订单
            List<FundOrderDto> flight = fundOrderDtos.stream().filter(e ->
                    FundStatusEnum.getEnumByCode(e.getFundStatus()) == FundStatusEnum.SUCCESS
            ).collect(Collectors.toList());
            //计算退款成功的金额
            if (CollectionUtils.isNotEmpty(flight)){
                for (FundOrderDto fundOrderDto : flight){
                    baseAmt += fundOrderDto.getAmt();
                }
            }

        }
        return baseAmt;
    }
}
