package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.BannerDto;
import com.qiho.center.api.enums.BannerTypeEnum;
import com.qiho.center.api.remoteservice.RemoteBannerService;
import com.qiho.manager.biz.service.BannerService;
import com.qiho.manager.biz.vo.BannerVO;
import com.qiho.manager.common.exception.QihoManagerException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author chensong
 * @create 2017-10-26 11:53
 **/
@Service
public class BannerServiceImpl implements BannerService {

    @Autowired
    private RemoteBannerService remoteBannerService;


    @Override
    public List<BannerVO> getBannerList(String bannerType) {
        List<BannerDto> bannerDtos = remoteBannerService.getAllBanners(bannerType).getResult();
        return convertToVOList(bannerDtos);
    }

    @Override
    public BannerVO findBannerById(Long id) {
        BannerDto dto = remoteBannerService.getBannerById(id).getResult();
        if(dto.getId() == null){
            throw new QihoManagerException("Banner不存在");
        }
        return convertToVOList(Lists.newArrayList(dto)).get(0);
    }

    @Override
    public Boolean saveBanner(BannerDto dto) {
        Boolean result = null;
        switch (dto.getBannerType()){
            case CAROUSEL:
                result = saveCarousel(dto);
                break;
            case RECOMMEND:
                result = saveRecommend(dto);
                break;
            default:
                break;
        }
        return result;
    }

    private Boolean saveCarousel(BannerDto dto){
        if(dto.getPayload() == null){
            int maxPayload = remoteBannerService.findMaxPayload().getResult();
            dto.setPayload(++maxPayload);
        }
        return remoteBannerService.saveBanner(dto).getResult();
    }

    private Boolean saveRecommend(BannerDto dto){
        List<BannerDto> bannerList = remoteBannerService.getAllBanners(BannerTypeEnum.RECOMMEND.getCode()).getResult();
        dto.setPayload(0);
        if (CollectionUtils.isEmpty(bannerList)){
            return remoteBannerService.saveBanner(dto).getResult();
        }
        // 校验生效时间是否和已有的时间有交集
        for (BannerDto banner : bannerList){
            if (dto.getStartTime().getTime()>=banner.getEndTime().getTime()
                    || dto.getEndTime().getTime()<=banner.getStartTime().getTime()
                    || dto.getId().intValue() == banner.getId().intValue()) {
                continue;
            } else {
                throw new QihoManagerException("生效周期错误");
            }
        }
        return remoteBannerService.saveBanner(dto).getResult();
    }

    private List<BannerVO> convertToVOList(List<BannerDto> dtoList){
        if(CollectionUtils.isEmpty(dtoList)){
            return Lists.newArrayList();
        }
        List<BannerVO> bannerVOList = new ArrayList<>();
        for(BannerDto dto:dtoList) {
            BannerVO bannerVO = BeanUtils.copy(dto, BannerVO.class);
            bannerVO.setBannerType(dto.getBannerType().getCode());
            bannerVO.setStartTime(DateUtils.getSecondStr(dto.getStartTime()));
            bannerVO.setEndTime(DateUtils.getSecondStr(dto.getEndTime()));
            bannerVO.setGmtCreate(DateUtils.getSecondStr(dto.getGmtCreate()));
            bannerVO.setGmtModified(DateUtils.getSecondStr(dto.getGmtModified()));
            bannerVOList.add(bannerVO);
        }
        return bannerVOList;
    }
}
