package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.constant.SystemConstant;
import com.qiho.center.api.dto.DetailRecommendDto;
import com.qiho.center.api.remoteservice.RemoteDetailRecommendService;
import com.qiho.manager.biz.service.DetailRecommendService;
import com.qiho.manager.biz.vo.DetailRecommendVO;
import com.qiho.manager.biz.vo.ItemVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by weny.cai on 2017/9/20.
 */
@Service
public class DetailRecommendServiceImpl implements DetailRecommendService {

    @Autowired
    RemoteDetailRecommendService remoteDetailRecommendService;

    @Override
    public ItemVO queryItemDetail(Long itemId) {
        return BeanUtils.copy(remoteDetailRecommendService.queryItemDetail(itemId).getResult(),ItemVO.class);
    }

    @Override
    public DubboResult<Boolean> saveDetailRecommend(List<DetailRecommendDto> list) {
        return remoteDetailRecommendService.saveDetailRecommend(list);
    }

    @Override
    public List<DetailRecommendVO> queryDetailRecommend(Long itemId) {
        List<DetailRecommendDto> dtos = remoteDetailRecommendService.queryDetailRecommend(itemId).getResult();
        List<DetailRecommendVO> vos = Lists.newArrayList();
        for (DetailRecommendDto dto : dtos) {
            DetailRecommendVO vo = BeanUtils.copy(dto,DetailRecommendVO.class);
            vo.setIsOpen(SystemConstant.ON.equals(dto.getIsOpen()));
            vos.add(vo);
        }
        return vos;
    }
}
