/**
 * Project Name:qiho-manager-biz File Name:ItemPropertyServiceImpl.java Package Name:com.qiho.manager.biz.service.impl
 * Date:2017年5月23日上午11:43:27 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.SkuPropertyValueDto;
import com.qiho.center.api.remoteservice.RemoteItemPropertyService;
import com.qiho.manager.biz.service.ItemPropertyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * ClassName:ItemPropertyServiceImpl <br/>
 * Date: 2017年5月23日 上午11:43:27 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class ItemPropertyServiceImpl implements ItemPropertyService {

    @Autowired
    private RemoteItemPropertyService remoteItemPropertyService;

    @Override
    public Map<Long, String> savePropertyName(List<String> propertyNameList) {
        DubboResult<Map<Long, String>> result = remoteItemPropertyService.createPropertyNames(propertyNameList);
        return result.getResult();
    }

    @Override
    public Map<Long, String> savePropertyValue(List<SkuPropertyValueDto> propertyValueList) {
        DubboResult<Map<Long, String>> result = remoteItemPropertyService.createPropertyValues(propertyValueList);
        return result.getResult();
    }

    /**
     * @see com.qiho.manager.biz.service.ItemPropertyService#updatePropertyValue(java.lang.Long, java.lang.String)
     */
    @Override
    public void updatePropertyValue(Long id, String propertyValue) {
        remoteItemPropertyService.updatePropertyValue(id, propertyValue);
    }

    /**
     * @see com.qiho.manager.biz.service.ItemPropertyService#updatePropertyName(java.lang.Long, java.lang.String)
     */
    @Override
    public void updatePropertyName(Long id, String propertyName) {
        remoteItemPropertyService.updatePropertyName(id, propertyName);
    }

}
