package com.qiho.manager.biz.service.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.monitor.LogisticsMonitorPlanDto;
import com.qiho.center.api.enums.AreaEnum;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.MonitorPlanQueryParam;
import com.qiho.center.api.remoteservice.monitor.RemoteLogisticsMonitorPlanService;
import com.qiho.manager.biz.service.LogisticsMonitorPlanService;
import com.qiho.manager.biz.service.logistics.LogisticsService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.monitor.LogisticsMonitorPlanVO;
import com.qiho.manager.biz.vo.monitor.MonitorStrategyVO;
import org.apache.commons.codec.binary.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by qianjue on 2017/11/1.
 */
@Service
public class LogisticsMonitorPlanServiceImpl implements LogisticsMonitorPlanService {

	@Resource
	private RemoteLogisticsMonitorPlanService remoteLogisticsMonitorPlanService;
	@Resource
	private LogisticsService logisticsService;

	@Override
	public Pagenation<LogisticsMonitorPlanVO> queryPageList(MonitorPlanQueryParam queryParam) {
		Pagenation<LogisticsMonitorPlanVO> pagenation = new Pagenation<>();
		PagenationDto<LogisticsMonitorPlanDto> pagenationDto = remoteLogisticsMonitorPlanService.queryPageList(queryParam);
		pagenation.setTotal(pagenationDto.getTotal());
		if(pagenation.getTotal()==0){
			pagenation.setList(Lists.newArrayList());
			return pagenation;
		}
		List<LogisticsMonitorPlanVO> list = Lists.newArrayList();
		Map<String, String> map = logisticsService.getBaiqiLogisticsCodeToName();
		pagenationDto.getList().forEach(dto->{
			LogisticsMonitorPlanVO vo = BeanUtils.copy(dto,LogisticsMonitorPlanVO.class);
			vo.setStartTime(DateUtils.getDayStr(dto.getStartTime()));
			vo.setEndTime(DateUtils.getDayStr(dto.getEndTime()));
			vo.setLogisticsName(map.get(vo.getLogisticsCode()));
			list.add(vo);
		});
		pagenation.setList(list);
		return pagenation;
	}

	@Override
	public int saveLogisticsMonitorPlan(LogisticsMonitorPlanDto dto) {
		try{
			return remoteLogisticsMonitorPlanService.createMonitorPlan(dto);
		}catch(BizException e){
			throw new QihoException(e.getMessage());
		}
	}


	@Override
	public LogisticsMonitorPlanVO queryPlanDetailById(Long id) {
		LogisticsMonitorPlanDto planDto = remoteLogisticsMonitorPlanService.selectDetailById(id);

		LogisticsMonitorPlanVO planVO = BeanUtils.copy(planDto,LogisticsMonitorPlanVO.class);
		//设置物流名称
		planVO.setLogisticsName(logisticsService.getBaiqiLogisticsCodeToName().get(planVO.getLogisticsCode()));
		//设置开始时间和结束时间
		planVO.setStartTime(DateUtils.getDayStr(planDto.getStartTime()));
		planVO.setEndTime(DateUtils.getDayStr(planDto.getEndTime()));
		//修改列表里面的信息
		List<MonitorStrategyVO> strategyList = BeanUtils.copyList(planDto.getStrategyDtoList(),MonitorStrategyVO.class);
		strategyList.stream().forEach(strategy ->{
			//设置仓库名称
			strategy.setWarehouseName("富阳仓库");
			//设置监控点名称
			if(StringUtils.equals(strategy.getMonitorStatus(),OrderStatusEnum.TO_SEND.getCode())){
				strategy.setMonitorStatusName(OrderStatusEnum.TO_SEND.getDesc());
			}else{
				strategy.setMonitorStatusName(LogisticsOrderStatusEnum.getByCode(strategy.getMonitorStatus()).getDesc());
			}
			//设置省份区域名称
			strategy.setAreaInfoName(transformCodeToName(strategy.getAreaInfo()));
		});
		planVO.setStrategyList(strategyList);
		return planVO;
	}

	@Override
	public int deleteById(Long id) {
		return remoteLogisticsMonitorPlanService.deleteMonitorPlan(id);
	}


	private  String  transformCodeToName(String codeStr){
		List<String> codesList = Splitter.on(",").trimResults().splitToList(codeStr);
		StringBuilder sb = new StringBuilder();
		codesList.stream().forEach(code-> {
			AreaEnum area = AreaEnum.getAreaEnumByCode(code);
			sb.append(area.getName()).append(",");
		});
		return sb.toString().substring(0,sb.length()-1);
	}
}
