package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.SkinDto;
import com.qiho.center.api.dto.homepage.TabItemDto;
import com.qiho.center.api.dto.page.BaiqiPageDto;
import com.qiho.center.api.enums.ItemStatusEnum;
import com.qiho.center.api.enums.page.PageTypeEnum;
import com.qiho.center.api.params.TabItemParams;
import com.qiho.center.api.params.TabItemQueryParam;
import com.qiho.center.api.remoteservice.RemoteSkinService;
import com.qiho.center.api.remoteservice.homepage.RemoteTabItemService;
import com.qiho.center.api.remoteservice.page.RemotePageBackendService;
import com.qiho.manager.biz.params.QueryStyleParam;
import com.qiho.manager.biz.service.TabItemService;
import com.qiho.manager.biz.vo.StyleVO;
import com.qiho.manager.biz.vo.homepage.TabItemVO;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by qianjue on 2017/8/29.
 */
@Service
public class TabItemServiceImpl implements TabItemService{

	private static final Logger LOG = LoggerFactory.getLogger(TabItemServiceImpl.class);

	@Resource
	private RemoteTabItemService  remoteTabItemService;

	@Resource
	private RemoteSkinService remoteSkinService;

	@Resource
	private RemotePageBackendService remotePageBackendService;

	@Override
	public List<TabItemVO> queryHomePageTabItem(Long tabId) {

		TabItemQueryParam param = new TabItemQueryParam();
		param.setTabId(tabId);
		DubboResult<List<TabItemDto>> result = remoteTabItemService.findTabItemList(param);
		if (!result.isSuccess()) {
			return Lists.newArrayList();
		}
		List<TabItemDto> list = result.getResult();
		List<TabItemVO> voList = BeanUtils.copyList(list, TabItemVO.class);
		// 添加样式配置
        for (int i = 0; i < list.size(); i++) {
            String styleConfig = list.get(i).getStyleConfig();
            // 转换样式配置格式为json
            if (StringUtils.isNotBlank(styleConfig) && isJSON(styleConfig)) {
                voList.get(i).setStyleConfig(JSONObject.fromObject(styleConfig.replaceAll(" ", "")));
                // 获取json键值对
                Map<String, Object> map = voList.get(i).getStyleConfig();
                // 根据map中的信息查询对应的样式名称
                voList.get(i).setStyleName(getStyleName(map));
            }
        }
        return voList;
    }

	// 判断字符串是否为json格式
	private Boolean isJSON(String str) {
		try {
			JSONObject.fromObject(str);
			return true;
		} catch (Exception e) {
			return false;
		}
	}

    private String getStyleName(Map<String, Object> map) {
        // 获取样式信息 styleType：1-皮肤样式(skinId)/2-页面模板(pId)
        Long styleType, styleId;
        try {
            styleType = Long.parseLong(map.get("styleType").toString());
            styleId = Long.parseLong(map.get("styleId").toString());
        } catch (Exception e) {
            return "";
        }
        // 查询对应的样式名称
        if (styleType == 1) {
            SkinDto skinDto = remoteSkinService.querySkinById(styleId).getResult();
            return skinDto == null ? "" : skinDto.getSkinName();
        } else if (styleType == 2) {
            BaiqiPageDto baiqiPageDto = remotePageBackendService.findById(styleId);
            return baiqiPageDto == null ? "" : baiqiPageDto.getPageName();
        } else {
            return "";
        }
    }

	@Override
	public Integer saveTabItemList(Long tabId, List<Long> itemIdList) {
		List<TabItemParams> list = Lists.newArrayList();
		itemIdList.stream().forEach(itemId ->{
			TabItemParams params = new TabItemParams();
			params.setTabId(tabId);
			params.setItemId(itemId);
			list.add(params);
		});
		DubboResult<Integer> result = remoteTabItemService.saveTabItemList(list);
		if(!result.isSuccess()){
			return 0;
		}
		return result.getResult();
	}

	@Override
	public Integer deleteItem(List<Long> idlist) {
		DubboResult<Integer> result = remoteTabItemService.deleteTabItemByIdList(idlist);
		if(!result.isSuccess()){
			return 0;
		}
		return result.getResult();
	}

	@Override
	public Integer updateTabItemTopInfo(Integer topStatus, List<Long> idList, Long tabId) {
		DubboResult<Integer> result = remoteTabItemService.updateTabItemTopPayloadByList(idList,tabId,topStatus == 1 ? true : false);
		return result.getResult();
	}

	@Override
	public void updateStatusBatch(List<Long> itemIdList, Long tabId, Integer status, Long gmtModifier) {
		remoteTabItemService.updateStatus(itemIdList, tabId, status, gmtModifier);
	}

	@Override
	public List<TabItemVO> checkStatusAndStock(List<Long> itemIdList) {
		TabItemQueryParam param = new TabItemQueryParam();
		param.setItemIds(itemIdList);
		DubboResult<List<TabItemDto>> result = remoteTabItemService.findTabItemList(param);
		if (!result.isSuccess()) {
			return Lists.newArrayList();
		}
		List<TabItemVO> list = BeanUtils.copyList(result.getResult(), TabItemVO.class);
		List<TabItemVO> voList = new ArrayList<>();
		for (TabItemVO vo : list) {
			if (vo.getStock() != 0 && StringUtils.equals(vo.getItemStatus(), ItemStatusEnum.STATUS_ON.getCode())) {
				voList.add(vo);
			}
		}
		return voList;
	}

	@Override
	public List<TabItemVO> queryTabItemByTabIdAndItemIds(List<Long> itemIdList, Long tabId) {
		List<TabItemDto> dtoList = remoteTabItemService.queryTabItemByTabIdAndItemIds(itemIdList, tabId);
		return BeanUtils.copyList(dtoList, TabItemVO.class);
	}

	@Override
	public StyleVO getStyle(QueryStyleParam param) {
		JSONObject styleConfig = param.getStyleConfig();
		// 判断样式信息是否为JSON格式
		if (!isJSON(styleConfig.toString())) {
			return null;
		}

		// 获取样式信息
		Long styleType, styleId;
		try {
			styleType = Long.parseLong(styleConfig.get("styleType").toString());
			styleId = Long.parseLong(styleConfig.get("styleId").toString());
		} catch (Exception e) {
			return null;
		}

		// 查询样式信息
		StyleVO styleVO = new StyleVO();
		styleVO.setStyleConfig(styleConfig);
		if (styleType == 1) {
			// 样式为皮肤
			SkinDto skinDto = remoteSkinService.querySkinById(styleId).getResult();
			if (null != skinDto) {
				styleVO.setStyleName(skinDto.getSkinName());
			}
		} else if (styleType == 2) {
			// 样式为页面模板, 先判断是商品详情页还是商品集合页
			BaiqiPageDto baiqiPageDto = remotePageBackendService.findById(styleId);
			if (null == baiqiPageDto) {
				styleVO.setStyleName(null);
			}

			if (baiqiPageDto.getPageType().intValue() == PageTypeEnum.ITEM_DETAIL.getValue()
					||baiqiPageDto.getPageType().intValue() == PageTypeEnum.COMPONENT_ITEM_DETAIL.getValue()) {
				// 商品详情页 或者组件化的商品详情页
				styleVO.setStyleName(baiqiPageDto.getPageName());

			} else if (baiqiPageDto.getPageType().intValue() == PageTypeEnum.ITEM_COLLECTION.getValue()
					|| baiqiPageDto.getPageType().intValue() == PageTypeEnum.COMPONENT_COLLECTION_PAGE.getValue()) {
				// 商品集合页
				styleVO.setStyleName(null);
			}
		}
		return styleVO;
	}

	@Override
	public Integer saveStyle(QueryStyleParam param) {
		JSONObject styleConfigJson = param.getStyleConfig();
		// 判断样式信息是否为JSON格式
		if (!isJSON(styleConfigJson.toString())) {
			return null;
		}

		String styleConfig = styleConfigJson.toString();
		if (StringUtils.equals("0", styleConfigJson.get("styleType").toString())){
			styleConfig = "";
		}

		// 封装参数
		TabItemParams tabItemParams = new TabItemParams();
		tabItemParams.setItemId(param.getItemId());
		tabItemParams.setTabId(param.getTabId());
		tabItemParams.setStyleConfig(styleConfig);
		return remoteTabItemService.saveTabItem(tabItemParams).getResult();
	}

	@Override
	public Integer initTabItemStatus() {
		return remoteTabItemService.initTabItemStatus().getResult();
	}
}
