package com.qiho.manager.biz.service.impl.tag;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.CategoryDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.tag.TagTypeDto;
import com.qiho.center.api.params.tag.QueryTagTypeParam;
import com.qiho.center.api.remoteservice.tag.RemoteTagTypeService;
import com.qiho.manager.biz.service.tag.TagTypeService;
import com.qiho.manager.biz.vo.CategoryVO;
import com.qiho.manager.biz.vo.tag.TagTypeVO;
import com.qiho.manager.biz.vo.tag.TagVO;
import com.qiho.manager.common.exception.QihoManagerException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author chensong
 * @create 2018-03-27 09:58
 **/
@Service
public class TagTypeServiceImple implements TagTypeService {

    @Autowired
    private RemoteTagTypeService remoteTagTypeService;

    @Override
    public String saveType(TagTypeDto tagTypeDto, List<Long> categoryIds) {
        String adminName = RequestTool.getAdmin().getName();
        tagTypeDto.setModifier(adminName);
        if (tagTypeDto.getId() == null) {
            tagTypeDto.setCreator(adminName);
        }

        ResultDto<Boolean> resultDto = remoteTagTypeService.saveTagType(tagTypeDto, categoryIds);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        return "保存成功";

    }

    @Override
    public List<TagTypeVO> queryTagType(Long catagoryId, String typeName) {
        QueryTagTypeParam param = new QueryTagTypeParam();
        param.setCategoryId(catagoryId);
        param.setTypeName(typeName);
        List<TagTypeDto> tagTypeDtos = remoteTagTypeService.queryTagType(param);
        return BeanUtils.copyList(tagTypeDtos, TagTypeVO.class);
    }

    @Override
    public Boolean deleteTagType(Long id) {
        if (id == null) {
            throw new QihoManagerException("标签类型id不能为空");
        }
        return remoteTagTypeService.deleteTagType(id);
    }

    @Override
    public List<TagTypeVO> findByItemId(Long itemId) {
        ResultDto<List<TagTypeDto>> result = remoteTagTypeService.findByItemId(itemId);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        List<TagTypeDto> tagTypeDtos = result.getResult();
        if (CollectionUtils.isEmpty(tagTypeDtos)) {
            return Lists.newArrayList();
        }
        List<TagTypeVO> tagTypeVOList = Lists.newArrayList();
        for (TagTypeDto tagTypeDto :tagTypeDtos) {
            TagTypeVO tagTypeVO = BeanUtils.copy(tagTypeDto, TagTypeVO.class);
            tagTypeVO.setTagList(BeanUtils.copyList(tagTypeDto.getTagList(), TagVO.class));
            tagTypeVOList.add(tagTypeVO);
        }
        return tagTypeVOList;
    }

    @Override
    public List<CategoryVO> findCategoryByTypeId(Long typeId) {
        List<CategoryDto> categoryDtoList = remoteTagTypeService.findCategoryByTypeId(typeId);
        return BeanUtils.copyList(categoryDtoList, CategoryVO.class);
    }
}
