package com.qiho.manager.biz.service.item;

import com.qiho.center.api.dto.item.ItemEvaluateDto;
import com.qiho.manager.biz.vo.item.ItemEvaluateVO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * @author jiafeng.geng
 * @date 2018-8-21.
 */
public interface ItemEvaluateService {

    /**
     * 查询商品下的评价列表
     *
     * @param itemId 商品id
     * @return List<ItemEvaluateVO>
     */
    List<ItemEvaluateVO> queryItmeEvalList(Long itemId);

    /**
     * 新增商品评价
     *
     * @param itemEvaluateDto
     * @return Integer
     */
    Integer addItemEval(ItemEvaluateDto itemEvaluateDto);

    /**
     * 编辑商品评价
     *
     * @param itemEvaluateDto
     * @return Integer
     */
    Integer updateItemEval(ItemEvaluateDto itemEvaluateDto);

    /**
     * 删除商品评价
     *
     * @param itemEvalId 商品评价id
     * @return Integer
     */
    Integer deletedItemEval(Long itemEvalId);

    /**
     * 排序商品评价
     *
     * @param itemId      商品id
     * @param itemEvalIds 商品评价id列表
     * @return Integer
     */
    Integer sortItemEval(Long itemId, List<Long> itemEvalIds);

}
