package com.qiho.manager.biz.service.item.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.item.ItemEvaluateDto;
import com.qiho.center.api.enums.item.ItemEvaluateTypeEnum;
import com.qiho.center.api.remoteservice.item.RemoteItemEvaluateBackendService;
import com.qiho.manager.biz.service.item.ItemEvaluateService;
import com.qiho.manager.biz.vo.item.ItemEvaluateVO;
import com.qiho.manager.common.enums.ItemEvaluateSaveFailedEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author jiafeng.geng
 * @date 2018-8-21.
 */
@Service("itemEvaluateService")
public class ItemEvaluateServiceImpl implements ItemEvaluateService {

    private static final Logger LOGGER = LoggerFactory.getLogger(ItemEvaluateServiceImpl.class);

    private static final int MAX_SHOW_LEN = 50;

    @Resource
    private RemoteItemEvaluateBackendService remoteItemEvaluateBackendService;

    @Override
    public List<ItemEvaluateVO> queryItmeEvalList(Long itemId) {
        List<ItemEvaluateDto> itemEvaluateDtoList = remoteItemEvaluateBackendService.queryItmeEvalList(itemId);

        if (CollectionUtils.isEmpty(itemEvaluateDtoList)) {
            return Lists.newArrayList();
        }

        // 最多展示50条
        if (itemEvaluateDtoList.size() > MAX_SHOW_LEN) {
            itemEvaluateDtoList = itemEvaluateDtoList.subList(0, MAX_SHOW_LEN);
        }

        // 转换格式
        return BeanUtils.copyList(itemEvaluateDtoList, ItemEvaluateVO.class);
    }

    @Override
    public Integer addItemEval(ItemEvaluateDto itemEvaluateDto) {
        // 查询当前商品下的评论总数
        int count = remoteItemEvaluateBackendService.queryItemEvalCount(itemEvaluateDto.getItemId());
        // 评论总数超过50条则不能添加
        if (count < 0 || count >= MAX_SHOW_LEN) {
            return ItemEvaluateSaveFailedEnum.EXCESS_MAX_THRESHOLD.getCode();
        }

        // 评价类型, 1-用户评价/2-手动添加评价/3-Excel导入评价
        itemEvaluateDto.setEvaluateType(ItemEvaluateTypeEnum.MANUAL_EVAL.getCode());

        // 设置默认排序值为当前最大排序值+1
        Integer maxSort = remoteItemEvaluateBackendService.queryMaxSort(itemEvaluateDto.getItemId());
        itemEvaluateDto.setSort(maxSort == null ? 0 : maxSort + 1);
        return remoteItemEvaluateBackendService.addItemEval(itemEvaluateDto);
    }

    @Override
    public Integer updateItemEval(ItemEvaluateDto itemEvaluateDto) {
        return remoteItemEvaluateBackendService.updateItemEval(itemEvaluateDto);
    }

    @Override
    public Integer deletedItemEval(Long itemEvalId) {
        return remoteItemEvaluateBackendService.deletedItemEval(itemEvalId);
    }

    @Override
    public Integer sortItemEval(Long itemId, List<Long> itemEvalIds) {
        return remoteItemEvaluateBackendService.sortItemEval(itemId, itemEvalIds);
    }

}
