package com.qiho.manager.biz.service.orderexport;

import com.qiho.center.api.dto.orderexport.TemplateFieldDto;
import com.qiho.center.api.params.orderexport.OrderExportTemplateQueryParams;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.orderexport.FieldVO;
import com.qiho.manager.biz.vo.orderexport.OrderExportTemplateVO;
import com.qiho.manager.biz.vo.orderexport.TemplateFieldVO;

import java.util.List;

/**
 * 订单模板service
 *
 * @author peanut.huang
 * @date 2017/11/24.
 */
public interface OrderExportTemplateService {

    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    Pagenation<OrderExportTemplateVO> find4Page(OrderExportTemplateQueryParams param);

    /**
     * 模板下拉列表
     *
     * @return
     */
    List<OrderExportTemplateVO> find4Select();

    /**
     * 删除模板
     *
     * @param tempId 模板id
     * @return
     */
    Boolean deleteTemplate(Long tempId);

    /**
     * 保存模板
     *
     * @param tempId    模板id
     * @param tempName  模板名称
     * @return
     */
    Boolean saveTemplate(Long tempId, String tempName);

    /**
     * 获取模板字段列表
     *
     * @param tempId  模板id
     * @return
     */
    List<TemplateFieldVO> findTempFields(Long tempId);

    /**
     * 删除模板字段
     *
     * @param tempFieldId  模板字段关联表id
     * @return
     */
    Boolean deleteTempField(Long tempFieldId);

    /**
     * 保存模板字段
     *
     * @param templateFieldDto
     * @return
     */
    Boolean saveTempField(TemplateFieldDto templateFieldDto);

    /**
     * 查询单个模板字段
     *
     * @param tempFieldId   模板字段关联表主键id
     * @return
     */
    TemplateFieldVO findTempField(Long tempFieldId);

    /**
     * 字段下拉列表
     *
     * @return
     */
    List<FieldVO> selectFields();
}
