package com.qiho.manager.biz.service.tag;

import com.qiho.center.api.dto.tag.TagDto;
import com.qiho.center.api.params.tag.TagPageParam;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.tag.TagVO;

import java.util.List;

/**
 * @author chensong
 * @create 2018-03-22 14:14
 **/
public interface TagService {

    /**
     * 新增或修改操作
     * @param tagDto
     * @return
     */
    Boolean save(TagDto tagDto);

    /**
     * 删除标签
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 分页查询标签
     * @param param
     * @return
     */
    Pagenation<TagVO> queryPage(TagPageParam param);

    /**
     * 根据标签类型的id获取标签
     * @param typeId
     * @return
     */
    List<TagVO> findByTypeId(Long typeId);

    /**
     * 获取商品关联的标签
     * @param itemId
     * @return
     */
    List<TagVO> findItemTags(Long itemId);

    /**
     * 保存商品标签
     * @param itemId
     * @param tagIds
     * @return
     */
    Boolean saveItemTag(Long itemId, List<Long> tagIds);

}
