package com.qiho.manager.biz.service.template;

import com.qiho.center.api.params.template.MerchantBlackPagingParam;
import com.qiho.center.api.params.template.MerchantBlackParam;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.template.TemplateMerchantBlackVo;

/**
 * @author Wangpf
 * @description
 * @date 2020/2/11 2:56 PM
 */
public interface MerchantBlackService {

    /**
     * 新增短信模板商家黑名单
     *
     * @param merchantBlackListParam
     * @return
     */
    boolean save(MerchantBlackParam merchantBlackListParam);

    /**
     * 分页查询商家黑名单
     *
     * @param merchantBlackPagingParam 分页查询参数
     * @return
     */
    Pagenation<TemplateMerchantBlackVo> pageQuery(MerchantBlackPagingParam merchantBlackPagingParam);

    /**
     * 删除当前商家黑名单
     *
     * @param id
     * @return
     */
    boolean delete(Long id);
}
