package com.qiho.manager.biz.service.template.impl;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.tuia.advert.model.DubboResult;
import com.alibaba.fastjson.JSON;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.template.MerchantBlackDto;
import com.qiho.center.api.params.template.MerchantBlackPagingParam;
import com.qiho.center.api.params.template.MerchantBlackParam;
import com.qiho.center.api.remoteservice.template.RemoteMerchantBlackService;
import com.qiho.manager.biz.service.template.MerchantBlackService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.template.TemplateMerchantBlackVo;
import com.qiho.manager.common.enums.MessageManagementEnum;
import com.qiho.manager.common.exception.QihoManagerException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Wangpf
 * @description
 * @date 2020/2/11 5:50 PM
 */
@Service
public class MerchantBlackServiceImpl implements MerchantBlackService {

    private static final Logger LOGGER = LoggerFactory.getLogger(MerchantBlackServiceImpl.class);

    @Autowired
    private RemoteMerchantBlackService remoteMerchantBlackService;

    /**
     * 全部场景
     */
    private static final String ALL_SCENE = "ALL";

    @Override
    public boolean save(MerchantBlackParam merchantBlackListParam) {
        String remark = merchantBlackListParam.getRemark();
        if (remark != null && remark.length() > 30) {
            throw new QihoManagerException("The remark:" + remark + "is too long");
        }
        //设置创建者名称
        AdminDto admin = RequestTool.getAdmin();
        merchantBlackListParam.setCreator(admin == null ? StringUtils.EMPTY : admin.getName());

        DubboResult dubboResult = remoteMerchantBlackService.save(merchantBlackListParam);
        if (!dubboResult.isSuccess()) {
            throw new QihoManagerException(dubboResult.getMsg());
        }

        return dubboResult.isSuccess();
    }

    @Override
    public Pagenation<TemplateMerchantBlackVo> pageQuery(MerchantBlackPagingParam merchantBlackPagingParam) {
        Pagenation<TemplateMerchantBlackVo> pagenation = new Pagenation<>();
        if(ALL_SCENE.equals(merchantBlackPagingParam.getScene())){
            merchantBlackPagingParam.setScene(StringUtils.EMPTY);
        }

        PagenationDto<MerchantBlackDto> dtoPagenationDto = remoteMerchantBlackService.pageQuery(merchantBlackPagingParam);

        List<MerchantBlackDto> dtoPagenationDtoList = dtoPagenationDto.getList();
        Integer total = dtoPagenationDto.getTotal();
        if(CollectionUtils.isEmpty(dtoPagenationDtoList) || total == null || total <= 0){
            return pagenation;
        }
        buildSceneText(dtoPagenationDtoList);
        pagenation.setTotal(total);
        pagenation.setList(BeanUtils.copyList(dtoPagenationDtoList,TemplateMerchantBlackVo.class));
        return pagenation;
    }

    private void buildSceneText(List<MerchantBlackDto> dtoPagenationDtoList) {
        dtoPagenationDtoList.forEach(appWhiteDto -> {
            String scene = appWhiteDto.getScene();
            String desc = MessageManagementEnum.getDescByCode(scene);
            appWhiteDto.setScene(desc);
        });
    }

    @Override
    public boolean delete(Long id) {
        if (id == null) {
            throw new QihoManagerException("The param id can not be null");
        }
        boolean delete = remoteMerchantBlackService.delete(id);
        if(delete){
            LOGGER.info("Merchant black was deleted id:{},admin:{}",id,JSON.toJSONString(RequestTool.getAdmin()));
        }

        return delete;
    }
}
