/**
 * Project Name:qiho-manager-biz File Name:ItemDetailVO.java Package Name:com.qiho.manager.biz.vo
 * Date:2017年5月19日上午9:51:19 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.manager.biz.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * ClassName:ItemDetailVO <br/>
 * 商品详情 <br/>
 * Date: 2017年5月19日 上午9:51:19 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel(value = "商品详情")
public class ItemDetailVO extends ItemVO {

    @ApiModelProperty("类目层级列表,按照类目顺序存放类目ID")
    private List<Long>          categoryIdList;

    @ApiModelProperty("价格文案")
    private String              priceText;

    @ApiModelProperty("倒计时周期")
    private String              countDownCycle;

    @ApiModelProperty("倒计时至少剩余时间")
    private String              countDownLimit;

    @ApiModelProperty("发货方式，ERP-erp发货/MANUAL-手动发货")
    private String              delivery;

    @ApiModelProperty("商品详情")
    private String              detail;

    @ApiModelProperty("最后修改时间，格式yyyy-MM-dd HH:mm:ss")
    private String              gmtModified;

    @ApiModelProperty("最后修改人姓名")
    private String              gmtModifyName;

    @ApiModelProperty("最后修改人邮箱")
    private String              gmtModifyEmail;

    @ApiModelProperty("SKU属性信息")
    private List<SkuPropertyVO> skuProperties;

    @ApiModelProperty("SKU信息")
    private List<ItemSkuVO>     skuList;

    @ApiModelProperty("商品购买件数限制")
    private Integer             limitNumber;

    @ApiModelProperty("是否支持货到付款")
    private Boolean             supportCOD;

    @ApiModelProperty("主推商品ids")
    private String              mainRecomIds;

    @ApiModelProperty("商家ID")
    private Long      merchantId;


    @ApiModelProperty("商家名称")
    private String      merchantName;

    @ApiModelProperty("商家发货方式")
    private String      merchantDelivery;

    @ApiModelProperty("图片高度数组")
    private List<ItemImgVO>     imgHeight;

    @ApiModelProperty("商品主图地址")
    private String mainImgUrl;

    @ApiModelProperty("商品介绍")
    private String itemIntroduce;

    @ApiModelProperty("营销标签")
    private String saleLableUrl;

    /**
     * sso日志中描述字段
     */
    private String ssoDesc;

    public String getSsoDesc() {
        return ssoDesc;
    }

    public void setSsoDesc(String ssoDesc) {
        this.ssoDesc = ssoDesc;
    }

    public String getMainImgUrl() {
        return mainImgUrl;
    }

    public void setMainImgUrl(String mainImgUrl) {
        this.mainImgUrl = mainImgUrl;
    }

    public String getItemIntroduce() {
        return itemIntroduce;
    }

    public void setItemIntroduce(String itemIntroduce) {
        this.itemIntroduce = itemIntroduce;
    }

    public String getSaleLableUrl() {
        return saleLableUrl;
    }

    public void setSaleLableUrl(String saleLableUrl) {
        this.saleLableUrl = saleLableUrl;
    }

    /**
     * categoryIdList.
     *
     * @return the categoryIdList
     */
    public List<Long> getCategoryIdList() {
        return categoryIdList;
    }

    /**
     * categoryIdList.
     *
     * @param categoryIdList the categoryIdList to set
     */
    public void setCategoryIdList(List<Long> categoryIdList) {
        this.categoryIdList = categoryIdList;
    }

    /**
     * priceText.
     *
     * @return the priceText
     */
    public String getPriceText() {
        return priceText;
    }

    /**
     * priceText.
     *
     * @param priceText the priceText to set
     */
    public void setPriceText(String priceText) {
        this.priceText = priceText;
    }

    /**
     * countDownCycle.
     *
     * @return the countDownCycle
     */
    public String getCountDownCycle() {
        return countDownCycle;
    }

    /**
     * countDownCycle.
     *
     * @param countDownCycle the countDownCycle to set
     */
    public void setCountDownCycle(String countDownCycle) {
        this.countDownCycle = countDownCycle;
    }

    /**
     * countDownLimit.
     *
     * @return the countDownLimit
     */
    public String getCountDownLimit() {
        return countDownLimit;
    }

    /**
     * countDownLimit.
     *
     * @param countDownLimit the countDownLimit to set
     */
    public void setCountDownLimit(String countDownLimit) {
        this.countDownLimit = countDownLimit;
    }

    /**
     * delivery.
     *
     * @return the delivery
     */
    public String getDelivery() {
        return delivery;
    }

    /**
     * delivery.
     *
     * @param delivery the delivery to set
     */
    public void setDelivery(String delivery) {
        this.delivery = delivery;
    }

    /**
     * detail.
     *
     * @return the detail
     */
    public String getDetail() {
        return detail;
    }

    /**
     * detail.
     *
     * @param detail the detail to set
     */
    public void setDetail(String detail) {
        this.detail = detail;
    }

    /**
     * gmtModified.
     *
     * @return the gmtModified
     */
    public String getGmtModified() {
        return gmtModified;
    }

    /**
     * gmtModified.
     *
     * @param gmtModified the gmtModified to set
     */
    public void setGmtModified(String gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * gmtModifyName.
     *
     * @return the gmtModifyName
     */
    public String getGmtModifyName() {
        return gmtModifyName;
    }

    /**
     * gmtModifyName.
     *
     * @param gmtModifyName the gmtModifyName to set
     */
    public void setGmtModifyName(String gmtModifyName) {
        this.gmtModifyName = gmtModifyName;
    }

    /**
     * gmtModifyEmail.
     *
     * @return the gmtModifyEmail
     */
    public String getGmtModifyEmail() {
        return gmtModifyEmail;
    }

    /**
     * gmtModifyEmail.
     *
     * @param gmtModifyEmail the gmtModifyEmail to set
     */
    public void setGmtModifyEmail(String gmtModifyEmail) {
        this.gmtModifyEmail = gmtModifyEmail;
    }

    
    /**
     * skuProperties.
     *
     * @return  the skuProperties
     */
    public List<SkuPropertyVO> getSkuProperties() {
        return skuProperties;
    }

    
    /**
     * skuProperties.
     *
     * @param   skuProperties    the skuProperties to set
     */
    public void setSkuProperties(List<SkuPropertyVO> skuProperties) {
        this.skuProperties = skuProperties;
    }

    /**
     * skuList.
     *
     * @return the skuList
     */
    public List<ItemSkuVO> getSkuList() {
        return skuList;
    }

    /**
     * skuList.
     *
     * @param skuList the skuList to set
     */
    public void setSkuList(List<ItemSkuVO> skuList) {
        this.skuList = skuList;
    }

    public Integer getLimitNumber() {
        return limitNumber;
    }

    public void setLimitNumber(Integer limitNumber) {
        this.limitNumber = limitNumber;
    }

    public Boolean getSupportCOD() {
        return supportCOD;
    }

    public void setSupportCOD(Boolean supportCOD) {
        this.supportCOD = supportCOD;
    }

    public String getMainRecomIds() {
        return mainRecomIds;
    }

    public void setMainRecomIds(String mainRecomIds) {
        this.mainRecomIds = mainRecomIds;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getMerchantDelivery() {
        return merchantDelivery;
    }

    public void setMerchantDelivery(String merchantDelivery) {
        this.merchantDelivery = merchantDelivery;
    }

    public List<ItemImgVO> getImgHeight() {
        return imgHeight;
    }

    public void setImgHeight(List<ItemImgVO> imgHeight) {
        this.imgHeight = imgHeight;
    }
}
