/**
 * Project Name:qiho-manager-biz File Name:ItemSkuVO.java Package Name:com.qiho.manager.biz.vo Date:2017年5月19日下午2:00:44
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.manager.biz.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:ItemSkuVO <br/>
 * 商品SKU信息. <br/>
 * Date: 2017年5月19日 下午2:00:44 <br/>
 * 
 * @author zhanglihui
 * @version
 * @see
 */
@ApiModel(value = "商品SKU信息")
public class ItemSkuVO {

    @ApiModelProperty("skuId")
    private Long    id;

    @ApiModelProperty("剩余库存")
    private Long    stock;

    @ApiModelProperty("库存ID")
    private String    stockId;

    @ApiModelProperty("售价，单位：分")
    private Integer sellingPrice;

    @ApiModelProperty("原价，单位：分")
    private Integer originalPrice;

    @ApiModelProperty("成本价，单位：分")
    private Integer costPrice;

    @ApiModelProperty("到付价格/用户真实付费价格，单位：分")
    private Integer realPayPrice;

    @ApiModelProperty("SKU属性键值对，属性名ID:属性值ID")
    private String  properties;

    @ApiModelProperty("商品编码")
    private String  skuNo;

    @ApiModelProperty("是否有效")
    private Boolean skuEnable;

    /**
     * id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * stock.
     *
     * @return the stock
     */
    public Long getStock() {
        return stock;
    }

    /**
     * stock.
     *
     * @param stock the stock to set
     */
    public void setStock(Long stock) {
        this.stock = stock;
    }

    /**
     * stockId.
     *
     * @return the stockId
     */
    public String getStockId() {
        return stockId;
    }

    /**
     * stockId.
     *
     * @param stockId the stockId to set
     */
    public void setStockId(String stockId) {
        this.stockId = stockId;
    }

    /**
     * sellingPrice.
     *
     * @return the sellingPrice
     */
    public Integer getSellingPrice() {
        return sellingPrice;
    }

    /**
     * sellingPrice.
     *
     * @param sellingPrice the sellingPrice to set
     */
    public void setSellingPrice(Integer sellingPrice) {
        this.sellingPrice = sellingPrice;
    }

    /**
     * originalPrice.
     *
     * @return the originalPrice
     */
    public Integer getOriginalPrice() {
        return originalPrice;
    }

    /**
     * originalPrice.
     *
     * @param originalPrice the originalPrice to set
     */
    public void setOriginalPrice(Integer originalPrice) {
        this.originalPrice = originalPrice;
    }

    /**
     * costPrice.
     *
     * @return the costPrice
     */
    public Integer getCostPrice() {
        return costPrice;
    }

    /**
     * costPrice.
     *
     * @param costPrice the costPrice to set
     */
    public void setCostPrice(Integer costPrice) {
        this.costPrice = costPrice;
    }

    /**
     * properties.
     *
     * @return the properties
     */
    public String getProperties() {
        return properties;
    }

    /**
     * properties.
     *
     * @param properties the properties to set
     */
    public void setProperties(String properties) {
        this.properties = properties;
    }

    /**
     * skuNo.
     *
     * @return the skuNo
     */
    public String getSkuNo() {
        return skuNo;
    }

    /**
     * skuNo.
     *
     * @param skuNo the skuNo to set
     */
    public void setSkuNo(String skuNo) {
        this.skuNo = skuNo;
    }

    /**
     * skuEnable.
     *
     * @return the skuEnable
     */
    public Boolean getSkuEnable() {
        return skuEnable;
    }

    /**
     * skuEnable.
     *
     * @param skuEnable the skuEnable to set
     */
    public void setSkuEnable(Boolean skuEnable) {
        this.skuEnable = skuEnable;
    }

    public Integer getRealPayPrice() {
        return realPayPrice;
    }

    public void setRealPayPrice(Integer realPayPrice) {
        this.realPayPrice = realPayPrice;
    }
}
