package com.qiho.manager.biz.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Created by weny.cai on 2017/8/29.
 */
@ApiModel(value = "主推商品展示对象")
public class MainItemVO {

    @ApiModelProperty("主推商品id")
    private Long id;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("主推标题")
    private String title;

    @ApiModelProperty("主推图片")
    private String image;

    @ApiModelProperty("总销量")
    private Integer saleNumStr;

    @ApiModelProperty(value = "商品状态，ON-上架/OFF-下架", required = true)
    private String             itemStatus;

    @ApiModelProperty(value = "最低价格，单位：分", required = true)
    private Integer            minPrice;

    @ApiModelProperty(value = "商品货号")
    private String             itemNo;

    @ApiModelProperty(value = "库存", required = true)
    private Long               stock;

    @ApiModelProperty(value = "排序字段", required = true)
    private Integer payload;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Integer getSaleNumStr() {
        return saleNumStr;
    }

    public void setSaleNumStr(Integer saleNumStr) {
        this.saleNumStr = saleNumStr;
    }

    public String getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(String itemStatus) {
        this.itemStatus = itemStatus;
    }

    public Integer getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(Integer minPrice) {
        this.minPrice = minPrice;
    }

    public String getItemNo() {
        return itemNo;
    }

    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    public Long getStock() {
        return stock;
    }

    public void setStock(Long stock) {
        this.stock = stock;
    }

    public Integer getPayload() {
        return payload;
    }

    public void setPayload(Integer payload) {
        this.payload = payload;
    }
}
