/**
 * Project Name:qiho-manager-biz File Name:Pagenation.java Package Name:com.qiho.manager.biz.vo Date:2017年5月17日下午5:30:02
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.manager.biz.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * ClassName:Pagenation <br/>
 * 分页对象 <br/>
 * Date: 2017年5月17日 下午5:30:02 <br/>
 * 
 * @author zhanglihui
 * @version
 * @param <T>
 * @see
 */
@ApiModel("分页数据")
public class Pagenation<T> {

    @ApiModelProperty("当前页的数据")
    private List<T> list;

    @ApiModelProperty("总条数")
    private int     total;

    public Pagenation() {
        this.list = Collections.emptyList();
        this.total = 0;
    }

    /**
     * list.
     *
     * @return the list
     */
    public List<T> getList() {
        return list;
    }

    /**
     * list.
     *
     * @param list the list to set
     */
    public void setList(List<T> list) {
        this.list = list;
    }

    /**
     * total.
     *
     * @return the total
     */
    public int getTotal() {
        return total;
    }

    /**
     * total.
     *
     * @param total the total to set
     */
    public void setTotal(int total) {
        this.total = total;
    }

    /**
     * 返回一个空的分页对象
     * @return
     */
    public Pagenation<T> emptyPage(){
        this.total = 0;
        this.setList(new ArrayList<>());
        return this;
    }

}
