/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.process.component;

import cn.com.duiba.boot.profiler.DBTimeProfiler;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.qiho.center.api.dto.component.ComponentDto;
import com.qiho.center.api.remoteservice.component.RemoteComponentService;
import com.qiho.manager.biz.params.component.ComponentPagePreParam;
import com.qiho.manager.biz.runnable.DownloadComponentCodeRunnable;
import com.qiho.manager.biz.vo.component.ComponentCodeVO;
import com.qiho.manager.biz.vo.component.ComponentPagePreviewVO;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.util.FileIDGenerator;
import com.qiho.manager.common.util.UploadTool;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.app.VelocityEngine;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;

public abstract class ComponentPageProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentPageProcessor.class);
    protected static final String HTTP_URL_PRE = "http:";
    protected static final String PATH_PRE = "component/page/";
    protected static final String DATETIME_FORMAT = "yyyyMMdd";
    protected static final String URL_SEPARATOR = "/";
    protected static final String HTML_URL_KEY = "htmlUrl";
    protected static final String HTML_MD5_KEY = "htmlMd5";
    protected static final String CSS_URL_KEY = "cssUrl";
    protected static final String JS_URL_KEY = "jsUrl";
    protected static final String HTML_CODE_KEY = "htmlCode";
    @Value(value="${oss.objectPath}")
    protected String ossYunUrl;
    @Autowired
    protected VelocityEngine velocityEngine;
    @Resource
    protected ExecutorService executorService;
    @Autowired
    protected RemoteComponentService remoteComponentService;
    @Autowired
    protected ApplicationContext applicationContext;

    public abstract ComponentPagePreviewVO preview(ComponentPagePreParam var1);

    @DBTimeProfiler
    protected Map<Long, ComponentCodeVO> downloadCode(List<ComponentDto> componentDtoList) {
        ConcurrentHashMap<Long, ComponentCodeVO> resultMap = new ConcurrentHashMap<Long, ComponentCodeVO>(16);
        CountDownLatch latch = new CountDownLatch(componentDtoList.size());
        for (ComponentDto componentDto : componentDtoList) {
            DownloadComponentCodeRunnable runnable = (DownloadComponentCodeRunnable)this.applicationContext.getBean(DownloadComponentCodeRunnable.class);
            runnable.setComponentId(componentDto.getId());
            runnable.setFileUrl(componentDto.getCodeUrl());
            runnable.setLatch(latch);
            runnable.setResultMap(resultMap);
            this.executorService.submit(runnable);
        }
        try {
            latch.await(20L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.error("\u4ee3\u7801\u89e3\u6790\u9519\u8bef\uff0cdata = {} ", componentDtoList, (Object)e);
            throw new QihoManagerException("\u7ec4\u4ef6\u4ee3\u7801\u89e3\u6790\u9519\u8bef," + e.getMessage());
        }
        if (resultMap.size() != componentDtoList.size()) {
            throw new QihoManagerException("\u7ec4\u4ef6\u4ee3\u7801\u89e3\u6790\u9519\u8bef");
        }
        return resultMap;
    }

    protected Map<String, String> buildCodeFile(Map<Long, ComponentCodeVO> codeMap, List<Long> idList) {
        StringBuilder htmlBuilder = new StringBuilder();
        StringBuilder cssBuilder = new StringBuilder();
        StringBuilder jsBuilder = new StringBuilder();
        for (Long id : idList) {
            ComponentCodeVO componentCode = codeMap.get(id);
            if (componentCode == null) {
                LOGGER.error("\u4ee3\u7801\u62fc\u63a5\u5931\u8d25\uff0c\u7ec4\u4ef6id = [{}] \u4e3anull", (Object)id);
                throw new QihoManagerException("\u4ee3\u7801\u7ec4\u5408\u5931\u8d25, \u7ec4\u4ef6id=" + id + "\u4ee3\u7801\u4e0d\u5b58\u5728");
            }
            htmlBuilder.append(this.skipBlank(componentCode.getHtmlCode())).append("\r\n");
            cssBuilder.append(this.skipBlank(componentCode.getCssCode()));
            jsBuilder.append(this.skipBlank(componentCode.getJsCode()));
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        this.uploadCssFile(resultMap, cssBuilder.toString(), idList);
        this.uploadJsFile(resultMap, jsBuilder.toString(), idList);
        resultMap.put(HTML_CODE_KEY, htmlBuilder.toString());
        return resultMap;
    }

    private String skipBlank(String str) {
        return StringUtils.isBlank((String)str) ? "" : str;
    }

    protected void uploadCssFile(Map<String, String> resultMap, String cssCode, List<Long> idList) {
        if (StringUtils.isBlank((String)cssCode)) {
            LOGGER.error("css\u4ee3\u7801\u4e3a\u7a7a\uff0c\u7ec4\u4ef6id={}", idList);
            throw new QihoManagerException("Css\u4ee3\u7801\u4e3a\u7a7a");
        }
        String cssFileName = FileIDGenerator.getRandomString((int)10);
        try {
            File cssFile = File.createTempFile(cssFileName, ".css");
            CharSink charSink = Files.asCharSink((File)cssFile, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND});
            charSink.write((CharSequence)cssCode);
            String cssFilePath = PATH_PRE + new DateTime().toString(DATETIME_FORMAT) + URL_SEPARATOR + cssFile.getName();
            boolean cssResult = UploadTool.uploadOssCss((File)cssFile, (String)cssFilePath);
            if (!cssResult) {
                throw new QihoManagerException("\u4e0a\u4f20Css\u6587\u4ef6\u5931\u8d25");
            }
            resultMap.put(CSS_URL_KEY, this.ossYunUrl + cssFilePath);
        }
        catch (Exception e) {
            LOGGER.error("\u4e0a\u4f20CSS\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new QihoManagerException(e.getMessage());
        }
    }

    protected void uploadJsFile(Map<String, String> resultMap, String jsCode, List<Long> idList) {
        if (StringUtils.isBlank((String)jsCode)) {
            LOGGER.error("Js\u4ee3\u7801\u4e3a\u7a7a\uff0c\u7ec4\u4ef6id={}", idList);
            throw new QihoManagerException("Js\u4ee3\u7801\u4e3a\u7a7a");
        }
        String jsFileName = FileIDGenerator.getRandomString((int)10);
        try {
            File cssFile = File.createTempFile(jsFileName, ".js");
            CharSink charSink = Files.asCharSink((File)cssFile, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND});
            charSink.write((CharSequence)jsCode);
            String cssFilePath = PATH_PRE + new DateTime().toString(DATETIME_FORMAT) + URL_SEPARATOR + cssFile.getName();
            boolean jsResult = UploadTool.uploadOssCss((File)cssFile, (String)cssFilePath);
            if (!jsResult) {
                throw new QihoManagerException("\u4e0a\u4f20Js\u6587\u4ef6\u5931\u8d25");
            }
            resultMap.put(JS_URL_KEY, this.ossYunUrl + cssFilePath);
        }
        catch (Exception e) {
            LOGGER.error("\u4e0a\u4f20JS\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new QihoManagerException(e.getMessage());
        }
    }
}

