/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.process.component;

import cn.com.duiba.wolf.utils.SecurityUtils;
import com.google.common.collect.Sets;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.qiho.center.api.dto.component.ComponentDto;
import com.qiho.center.api.enums.component.ComponentTypeEnum;
import com.qiho.center.api.enums.component.ComponentUsageTypeEnum;
import com.qiho.center.api.enums.page.PageTypeEnum;
import com.qiho.manager.biz.params.component.ComponentPagePreParam;
import com.qiho.manager.biz.process.component.ComponentPageDecider;
import com.qiho.manager.biz.process.component.ComponentPageProcessor;
import com.qiho.manager.biz.vo.component.ComponentCodeVO;
import com.qiho.manager.biz.vo.component.ComponentPagePreviewVO;
import com.qiho.manager.common.constant.DomainConstantUtil;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.util.AssertUtil;
import com.qiho.manager.common.util.FileIDGenerator;
import com.qiho.manager.common.util.UploadTool;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.app.VelocityEngine;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.ui.velocity.VelocityEngineUtils;

@Component
public class ItemComponentPageProcessor
extends ComponentPageProcessor
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemComponentPageProcessor.class);
    @Value(value="${component.page.vendor.js}")
    private String vendorJsUrl;
    @Value(value="${component.page.main.js}")
    private String mainJsUrl;
    @Value(value="${component.page.base.css}")
    private String baseCssUrl;

    public void afterPropertiesSet() throws Exception {
        ComponentPageDecider.registerPorcessor(PageTypeEnum.COMPONENT_ITEM_DETAIL, this);
    }

    @Override
    public ComponentPagePreviewVO preview(ComponentPagePreParam param) {
        List<Long> idList = param.fetchComponentIds();
        List<ComponentDto> componentDtoList = this.checkPreParam(param, idList);
        Map<String, String> htmlMap = this.packageCode(componentDtoList, param, idList);
        ComponentPagePreviewVO componentPre = new ComponentPagePreviewVO();
        componentPre.setMd5(htmlMap.get("htmlMd5"));
        String htmlFileUrl = htmlMap.get("htmlUrl");
        componentPre.setPageFileUrl(htmlFileUrl);
        String prePath = DomainConstantUtil.getQihoWebUrl() + "/page/preview?id=" + param.getId() + "&fileUrl=" + htmlFileUrl;
        componentPre.setPreUrl(prePath);
        return componentPre;
    }

    protected List<ComponentDto> checkPreParam(ComponentPagePreParam param, List<Long> idList) {
        AssertUtil.collectionNotEmpty(param.getList(), (String)"\u7ec4\u4ef6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        List componentDtoList = this.remoteComponentService.listBatchByIds(idList);
        HashSet idSet = Sets.newHashSet(idList);
        if (idSet.size() != componentDtoList.size()) {
            idSet.removeAll(componentDtoList.stream().map(ComponentDto::getId).collect(Collectors.toSet()));
            throw new QihoManagerException("\u7ec4\u4ef6id = " + ((Object)idSet).toString() + "\u4e0d\u5b58\u5728");
        }
        List requiredComponentList = ComponentTypeEnum.fetchNecessaryComponent((ComponentUsageTypeEnum)ComponentUsageTypeEnum.ITEM_DEATIL);
        for (ComponentTypeEnum componentTypeEnum : requiredComponentList) {
            boolean flag = false;
            for (ComponentDto componentDto : componentDtoList) {
                if (!componentTypeEnum.equals((Object)componentDto.getComponentType())) continue;
                flag = true;
            }
            if (flag) continue;
            throw new QihoManagerException(componentTypeEnum.getDesc() + "\u7c7b\u578b\u7ec4\u4ef6\u4e0d\u5b58\u5728");
        }
        return componentDtoList;
    }

    private Map<String, String> packageCode(List<ComponentDto> componentDtoList, ComponentPagePreParam param, List<Long> idList) {
        Map<Long, ComponentCodeVO> componentCodeMap = this.downloadCode(componentDtoList);
        Map<String, String> codeFileMap = this.buildCodeFile(componentCodeMap, idList);
        return this.renderTemplate(codeFileMap, param);
    }

    private Map<String, String> renderTemplate(Map<String, String> codeFileMap, ComponentPagePreParam param) {
        if (StringUtils.isBlank((String)codeFileMap.get("cssUrl")) || StringUtils.isBlank((String)codeFileMap.get("jsUrl"))) {
            LOGGER.error("\u83b7\u53d6\u4ee3\u7801\u5931\u8d25\uff0ccodeFileMap = {}", codeFileMap);
            throw new QihoManagerException("\u4ee3\u7801\u83b7\u53d6\u5931\u8d25");
        }
        HashMap<String, String> model = new HashMap<String, String>(16);
        model.put("jsReplace", codeFileMap.get("jsUrl"));
        model.put("cssReplace", codeFileMap.get("cssUrl"));
        model.put("htmlReplace", codeFileMap.get("htmlCode"));
        model.put("jsConfigReplace", param.getTotalConfig());
        model.put("baseCssReplace", this.baseCssUrl);
        model.put("vendorJsReplace", this.vendorJsUrl);
        model.put("mainJsReplace", this.mainJsUrl);
        HashMap<String, String> htmlMap = new HashMap<String, String>(16);
        String context = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)"pageShell.vm", (String)"UTF-8", model);
        String md5 = SecurityUtils.encode2StringByMd5((String)context);
        htmlMap.put("htmlMd5", md5);
        String htmlFileName = FileIDGenerator.getRandomString((int)10);
        try {
            File htmlFile = File.createTempFile(htmlFileName, ".html");
            CharSink charSink = Files.asCharSink((File)htmlFile, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND});
            charSink.write((CharSequence)context);
            String htmlFilePath = "component/page/" + new DateTime().toString("yyyyMMdd") + "/" + htmlFile.getName();
            boolean jsResult = UploadTool.uploadOssHtml((File)htmlFile, (String)htmlFilePath);
            if (!jsResult) {
                throw new QihoManagerException("\u4e0a\u4f20Js\u6587\u4ef6\u5931\u8d25");
            }
            htmlMap.put("htmlUrl", "http:" + this.ossYunUrl + htmlFilePath);
        }
        catch (Exception e) {
            LOGGER.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new QihoManagerException(e.getMessage());
        }
        return htmlMap;
    }
}

