/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.runnable;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.remoteservice.RemoteLogisticsOrderService;
import com.qiho.manager.biz.params.OrdersLogisticsParam;
import com.qiho.manager.biz.runnable.BaseExportRunnable;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.util.AppLogUtil;
import com.qiho.manager.common.util.UploadTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DistributeOrderExportRunnable
extends BaseExportRunnable
implements Runnable {
    @Autowired
    private RemoteLogisticsOrderService remoteLogisticsOrderService;
    private File file;
    private String filePath = "logistics/";
    private Long taskId = System.currentTimeMillis();
    private static final int BATCH_NUM = 100;
    private Logger logger = LoggerFactory.getLogger(DistributeOrderExportRunnable.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int count = this.remoteLogisticsOrderService.queryDistributeOverTimeNum();
        int batch = this.getBatchs(count);
        CacheConstantseEnum constantseEnum = CacheConstantseEnum.EXPORT_DISTRIBUTE_LOGISTICS_ORDER;
        String key = constantseEnum.getCacheKey((Object)this.taskId);
        HashOperations operations = this.redisTemplate.opsForHash();
        Workbook workbook = null;
        try (FileOutputStream outputStream = new FileOutputStream(this.file);){
            ArrayList exportList = Lists.newArrayList();
            for (int i = 0; i < batch; ++i) {
                List result = this.remoteLogisticsOrderService.queryDistributeOverTimePage(Integer.valueOf(i), Integer.valueOf(100));
                List<OrdersLogisticsParam> list = this.transferExcelEntity(result);
                exportList.addAll(list);
                operations.increment((Object)key, (Object)"successCount", (long)list.size());
            }
            workbook = ExcelExportUtil.exportBigExcel((ExportParams)new ExportParams(), OrdersLogisticsParam.class, (Collection)exportList);
            workbook.write((OutputStream)outputStream);
            operations.put((Object)key, (Object)"message", (Object)"\u6587\u4ef6\u4e0a\u4f20\u4e2d");
            String url = UploadTool.uploadOssNotCDN((File)this.file, (String)(this.filePath + this.file.getName()), (String)"application/x-msdownload;charset=GBK");
            operations.put((Object)key, (Object)"url", (Object)url);
            operations.put((Object)key, (Object)"message", (Object)"\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)this.logger, (String)"DistributeOrderExportRunnable run error", (Object[])new Object[]{e});
            operations.put((Object)key, (Object)"message", (Object)e.getMessage());
        }
        finally {
            operations.put((Object)key, (Object)"success", (Object)"true");
            ExcelExportUtil.closeExportBigExcel();
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.file != null && this.file.exists() && !this.file.delete()) {
                AppLogUtil.warn((Logger)this.logger, (String)"file delete error or file not exists");
            }
        }
    }

    private int getBatchs(int count) {
        return count % 100 == 0 ? count / 100 : count / 100 + 1;
    }

    public Map<String, Object> init() {
        this.file = super.getFile2(this.filePath);
        return super.init(this.file, this.taskId, CacheConstantseEnum.EXPORT_DISTRIBUTE_LOGISTICS_ORDER);
    }

    private List<OrdersLogisticsParam> transferExcelEntity(List<LogisticsOrderDto> result) {
        ArrayList list = Lists.newArrayList();
        for (LogisticsOrderDto dto : result) {
            OrdersLogisticsParam ordersExport = (OrdersLogisticsParam)BeanUtils.copy((Object)dto, OrdersLogisticsParam.class);
            ordersExport.setLogisticsStatus(LogisticsOrderStatusEnum.getByCode((String)dto.getOrderStatus()).getDesc());
            list.add(ordersExport);
        }
        return list;
    }
}

