/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.runnable;

import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import com.qiho.manager.biz.vo.component.ComponentCodeVO;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.exception.QihoManagerException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DownloadComponentCodeRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadComponentCodeRunnable.class);
    private static final String CODE_SPLIT = "<split>";
    private static final Joiner LINE_JOINER = Joiner.on((String)"");
    private static final Splitter CODE_SPLITTER = Splitter.on((String)"<split>");
    private static final int DEAULT_CODE_NUM = 3;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;
    private String fileUrl;
    private Long componentId;
    private CountDownLatch latch;
    private Map<Long, ComponentCodeVO> resultMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (StringUtils.isBlank((CharSequence)this.fileUrl)) {
                throw new QihoManagerException("\u6587\u4ef6\u5730\u5740\u4e3a\u7a7a");
            }
            String code = this.getCodeFormCache();
            if (StringUtils.isNotBlank((CharSequence)code)) {
                this.splitCodeTOMap(code);
            } else {
                URL url = new URL(this.fileUrl);
                CharSource charset = Resources.asCharSource((URL)url, (Charset)Charsets.UTF_8);
                ImmutableList lines = charset.readLines();
                code = LINE_JOINER.join((Iterable)lines);
                if (StringUtils.isBlank((CharSequence)code)) {
                    LOGGER.error("oss\u8bfb\u53d6\u7ec4\u4ef6\u4ee3\u7801\u4e3a\u7a7a\uff0c\u7ec4\u4ef6id=[{}]\uff0cfileUrl=[{}] ", (Object)this.componentId, (Object)this.fileUrl);
                    throw new QihoManagerException("\u4ee3\u7801\u83b7\u53d6\u4e3a\u7a7a");
                }
                this.splitCodeTOMap(code);
                this.setCodeOnRedis(code);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u7ec4\u4ef6\u4ee3\u7801\u89e3\u6790\u9519\u8bef\uff0c componenntId=[{}], fileUrl=[{}]", new Object[]{this.componentId, this.fileUrl, e});
        }
        finally {
            this.latch.countDown();
        }
    }

    private void splitCodeTOMap(String code) {
        List codeList = CODE_SPLITTER.splitToList((CharSequence)code);
        if (codeList.size() != 3) {
            LOGGER.error("\u7ec4\u4ef6\u4ee3\u7801\u62c6\u5206\u5f02\u5e38\uff0c\u7ec4\u4ef6id=[{}]\uff0cfileUrl=[{}]", (Object)this.componentId, (Object)this.fileUrl);
            throw new QihoManagerException("\u4ee3\u7801\u62c6\u5206\u5f02\u5e38");
        }
        ComponentCodeVO componentCode = new ComponentCodeVO();
        componentCode.setHtmlCode((String)codeList.get(0));
        componentCode.setCssCode((String)codeList.get(1));
        componentCode.setJsCode((String)codeList.get(2));
        this.resultMap.put(this.componentId, componentCode);
    }

    private String getCodeFormCache() {
        String key = CacheConstantseEnum.COMPONENT_FILE_URL.toString() + ":" + this.componentId;
        return (String)this.advancedCacheClient.get(key);
    }

    private void setCodeOnRedis(String code) {
        String key = CacheConstantseEnum.COMPONENT_FILE_URL.toString() + ":" + this.componentId;
        this.advancedCacheClient.set(key, (Object)code, CacheConstantseEnum.COMPONENT_FILE_URL.getTime().intValue(), CacheConstantseEnum.COMPONENT_FILE_URL.getTimeUnit());
    }

    public void setComponentId(Long componentId) {
        this.componentId = componentId;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    public void setResultMap(Map<Long, ComponentCodeVO> resultMap) {
        this.resultMap = resultMap;
    }
}

