/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.runnable;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.qiho.center.api.dto.monitor.LogisticsMonitorReportDto;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.params.MonitorReportQueryParam;
import com.qiho.center.api.remoteservice.monitor.RemoteMonitorReportService;
import com.qiho.manager.biz.runnable.BaseExportRunnable;
import com.qiho.manager.biz.service.logistics.LogisticsService;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.util.AppLogUtil;
import com.qiho.manager.common.util.UploadTool;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Deprecated
public class MonitorReportExportRunnable
extends BaseExportRunnable
implements Runnable {
    private File file;
    private String filePath = "monitor/report/";
    private Long taskId = new Date().getTime();
    private String[] headersColumn = new String[]{"\u7269\u6d41\u516c\u53f8", "\u76d1\u63a7\u70b9", "\u6d89\u53ca\u8ba2\u5355\u603b\u6570", "\u6b63\u5e38\u8ba2\u5355\u6570", "\u9ec4\u724c\u8ba2\u5355\u6570", "\u7ea2\u724c\u8ba2\u5355\u6570"};
    private Logger logger = LoggerFactory.getLogger(MonitorReportExportRunnable.class);
    private MonitorReportQueryParam queryParam;
    @Resource
    private RemoteMonitorReportService remoteMonitorReportService;
    @Resource
    private LogisticsService logisticsService;

    public Map<String, Object> init() {
        this.file = super.getFile(this.filePath);
        return super.init(this.file, this.taskId, CacheConstantseEnum.EXPORT_MONITOR_REPORT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CharSink charSink = Files.asCharSink((File)this.file, (Charset)Charset.forName("GBK"), (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND});
        CacheConstantseEnum constantseEnum = CacheConstantseEnum.EXPORT_MONITOR_REPORT;
        String key = constantseEnum.getCacheKey((Object)this.taskId);
        HashOperations operations = this.redisTemplate.opsForHash();
        try {
            ArrayList headers = Lists.newArrayList((Object[])new String[]{this.joiner.join((Object[])this.headersColumn)});
            charSink.writeLines((Iterable)headers);
            MonitorReportToString transform = new MonitorReportToString();
            List result = this.remoteMonitorReportService.queryList(this.queryParam);
            List list = Lists.transform((List)result, (Function)transform);
            charSink.writeLines((Iterable)list);
            operations.increment((Object)key, (Object)"successCount", (long)list.size());
            operations.put((Object)key, (Object)"message", (Object)"\u6587\u4ef6\u4e0a\u4f20\u4e2d");
            String url = UploadTool.uploadOssNotCDN((File)this.file, (String)(this.filePath + this.file.getName()), (String)"application/csv;charset=GBK");
            operations.put((Object)key, (Object)"url", (Object)url);
            operations.put((Object)key, (Object)"message", (Object)"\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)this.logger, (String)"MonitorReportExportRunnable run error", (Object[])new Object[]{e});
            operations.put((Object)key, (Object)"message", (Object)e.getMessage());
        }
        finally {
            operations.put((Object)key, (Object)"success", (Object)"true");
            if (this.file != null && this.file.exists() && !this.file.delete()) {
                AppLogUtil.warn((Logger)this.logger, (String)"file delete error or file not exists");
            }
        }
    }

    public MonitorReportQueryParam getQueryParam() {
        return this.queryParam;
    }

    public void setQueryParam(MonitorReportQueryParam queryParam) {
        this.queryParam = queryParam;
    }

    private class MonitorReportToString
    implements Function<LogisticsMonitorReportDto, String> {
        private MonitorReportToString() {
        }

        public String apply(LogisticsMonitorReportDto input) {
            ArrayList row = Lists.newArrayList();
            row.add(MonitorReportExportRunnable.this.useForNull(MonitorReportExportRunnable.this.logisticsService.getBaiqiLogisticsCodeToName().get(input.getLogisticsCode())));
            row.add(MonitorReportExportRunnable.this.useForNull(StringUtils.equals((CharSequence)input.getMonitorStatus(), (CharSequence)OrderStatusEnum.TO_SEND.getCode()) ? OrderStatusEnum.TO_SEND.getDesc() : LogisticsOrderStatusEnum.getByCode((String)input.getMonitorStatus()).getDesc()));
            row.add(MonitorReportExportRunnable.this.useForNull(input.getOrderCountTotal()));
            row.add(MonitorReportExportRunnable.this.useForNull(input.getOrderCountNormal()));
            row.add(MonitorReportExportRunnable.this.useForNull(input.getOrderCountYellow()));
            row.add(MonitorReportExportRunnable.this.useForNull(input.getOrderCountRed()));
            return MonitorReportExportRunnable.this.joiner.join((Iterable)row);
        }
    }
}

