/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.runnable;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.es.OrderSnapshotESDto;
import com.qiho.center.api.dto.reply.UserReplyDto;
import com.qiho.center.api.params.OrderPageParams;
import com.qiho.center.api.remoteservice.order.RemoteOrderService;
import com.qiho.manager.biz.params.OrdersExportParam;
import com.qiho.manager.biz.runnable.BaseExportRunnable;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.util.UploadTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OrdersExportRunnable
extends BaseExportRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrdersExportRunnable.class);
    private static final int ORDER_EXPORT_MAX = 1000;
    @Autowired
    private RemoteOrderService remoteOrderService;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;
    private OrderPageParams params;
    private File file;
    private String filePath = "orders/";
    private Long taskId = System.currentTimeMillis();

    public Map<String, Object> init() {
        this.file = super.getFile2(this.filePath);
        return super.init(this.file, this.taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Integer exportCount = this.remoteOrderService.exportOrderESCount(this.params);
        int batch = this.getBatchs(exportCount);
        String redisKey = CacheConstantseEnum.EXPORT_ORDER_CACEL + ":" + this.taskId;
        CacheConstantseEnum constantseEnum = CacheConstantseEnum.EXPORT_ORDER;
        String key = constantseEnum.getCacheKey((Object)this.taskId);
        HashOperations operations = this.redisTemplate.opsForHash();
        Workbook workbook = null;
        try (FileOutputStream outputStream = new FileOutputStream(this.file);){
            ArrayList exportList = Lists.newArrayList();
            for (int i = 0; i < batch; ++i) {
                String redisTaskId = (String)this.advancedCacheClient.get(redisKey);
                if (StringUtils.isNotBlank((String)redisTaskId)) {
                    this.redisTemplate.delete((Object)key);
                    this.advancedCacheClient.remove(redisKey);
                    return;
                }
                this.params.setOffset(Integer.valueOf(i * 1000));
                OrderSnapshotESDto result = this.remoteOrderService.exportAllOrderPage(this.params);
                this.params.setScrollId(result.getScrollId());
                List<OrdersExportParam> list = this.transferExcelEntity(result.getList());
                exportList.addAll(list);
                operations.increment((Object)key, (Object)"successCount", (long)list.size());
            }
            workbook = ExcelExportUtil.exportBigExcel((ExportParams)new ExportParams(), OrdersExportParam.class, (Collection)exportList);
            workbook.write((OutputStream)outputStream);
            operations.put((Object)key, (Object)"message", (Object)"\u6587\u4ef6\u4e0a\u4f20\u4e2d");
            String url = UploadTool.uploadOssNotCDN((File)this.file, (String)(this.filePath + this.file.getName()), (String)"application/x-msdownload;charset=GBK");
            operations.put((Object)key, (Object)"url", (Object)url);
            operations.put((Object)key, (Object)"message", (Object)"\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("orders Export error msg={}", (Throwable)e);
            operations.put((Object)key, (Object)"message", (Object)e.getMessage());
        }
        finally {
            operations.put((Object)key, (Object)"success", (Object)"true");
            ExcelExportUtil.closeExportBigExcel();
            try {
                workbook.close();
            }
            catch (IOException e) {
                LOGGER.error("\u8d44\u6e90close\u5f02\u5e38", (Throwable)e);
            }
            if (this.file != null && this.file.exists() && !this.file.delete()) {
                LOGGER.warn("file delete error or file not exists");
            }
        }
    }

    private List<OrdersExportParam> transferExcelEntity(List<OrderSnapshotDto> result) {
        ArrayList list = Lists.newArrayList();
        for (OrderSnapshotDto dto : result) {
            OrdersExportParam ordersExport = (OrdersExportParam)BeanUtils.copy((Object)dto, OrdersExportParam.class);
            try {
                ordersExport.setOrderAmt((double)dto.getOrderAmt().intValue() / 100.0);
            }
            catch (Exception e) {
                LOGGER.info("\u6279\u91cf\u5bfc\u51fa\u8ba2\u5355-\u8bbe\u7f6e\u8ba2\u5355\u91d1\u989d\u9519\u8bef, dto={}", (Object)dto);
            }
            try {
                ordersExport.setSellingPrice((double)dto.getSellingPrice().intValue() / 100.0);
            }
            catch (Exception e) {
                LOGGER.info("\u6279\u91cf\u5bfc\u51fa\u8ba2\u5355-\u8bbe\u7f6e\u5546\u54c1\u4ef7\u683c\u9519\u8bef, dto={}", (Object)dto);
            }
            if (dto.getDeliveryEnum() == null) {
                ordersExport.setDelivery("");
            } else {
                ordersExport.setDelivery(dto.getDeliveryEnum().getDesc());
            }
            ordersExport.setOrderStatus(dto.getOrderStatusEnum().getDesc());
            String reply = this.convertReplyToString(dto.getUserReplyList());
            ordersExport.setUserReply(reply);
            list.add(ordersExport);
        }
        return list;
    }

    private String convertReplyToString(List<UserReplyDto> userReplyList) {
        if (CollectionUtils.isEmpty(userReplyList)) {
            return null;
        }
        StringBuilder userReplyBuilder = new StringBuilder();
        userReplyList.stream().forEach(e -> userReplyBuilder.append(new DateTime((Object)e.getGmtCreate()).toString("yyyy.MM.dd HH:mm:ss")).append(" ").append(e.getContent()).append("|"));
        String userReplyStr = userReplyBuilder.toString();
        return userReplyStr.substring(0, userReplyStr.length() - 1);
    }

    private int getBatchs(int total) {
        return total % 1000 == 0 ? total / 1000 : total / 1000 + 1;
    }

    public OrderPageParams getParams() {
        return this.params;
    }

    public void setParams(OrderPageParams params) {
        params.setMax(Integer.valueOf(1000));
        params.setOffset(Integer.valueOf(0));
        this.params = params;
    }
}

