/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.runnable.ordertaskhandler;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.qiho.center.api.dto.ErpOrderDto;
import com.qiho.center.api.enums.ErpStatusEnum;
import com.qiho.center.api.remoteservice.order.RemoteErpOrderService;
import com.qiho.manager.biz.runnable.AbstractOrderHandler;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpOrderReviewToFaildHandler
implements AbstractOrderHandler<ErpOrderDto> {
    private Splitter splitter = Splitter.on((String)",").trimResults().omitEmptyStrings().limit(2);
    private String remarks = "\u65fa\u5e97\u901a\u5ba1\u6838\u5931\u8d25-";
    @Autowired
    private RemoteErpOrderService remoteErpOrderService;

    @Override
    public ErpOrderDto transform(String row, String status) {
        ErpOrderDto erpOrderDto = new ErpOrderDto();
        List list = this.splitter.splitToList((CharSequence)row);
        if (CollectionUtils.isEmpty((Collection)list) || StringUtils.isBlank((String)((String)list.get(0)))) {
            return null;
        }
        erpOrderDto.setErpId((String)list.get(0));
        if (list.size() > 1) {
            erpOrderDto.setFailedMessage(this.remarks + (String)list.get(1));
        }
        erpOrderDto.setErpStatus(ErpStatusEnum.FAILED.getCode());
        return erpOrderDto;
    }

    @Override
    public ErpOrderDto transform(String row) {
        return this.transform(row, null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<ErpOrderDto> list) {
        DubboResult result = this.remoteErpOrderService.batchReviewFaildErpOrder(cacheKey, list);
        return (Integer)result.getResult();
    }

    @Override
    public Integer exeTask(String cacheKey, List<ErpOrderDto> list, JSONObject extraParams) {
        return this.exeTask(cacheKey, list);
    }
}

