/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.runnable.ordertaskhandler;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.qiho.center.api.dto.ExpressBlackListDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.ExpressBlackListPageParams;
import com.qiho.center.api.remoteservice.RemoteExpressBlackListService;
import com.qiho.manager.biz.runnable.BaseExportRunnable;
import com.qiho.manager.biz.service.ExpressBlackService;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.util.AppLogUtil;
import com.qiho.manager.common.util.UploadTool;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ExpressBlackListExportRunnable
extends BaseExportRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressBlackListExportRunnable.class);
    private ExpressBlackListPageParams params;
    @Autowired
    private ExpressBlackService expressBlackListService;
    @Autowired
    private RemoteExpressBlackListService remoteExpressBlackListService;
    private Long taskId = new Date().getTime();
    private String filePath = "expressBlackList/";
    private File file;
    private static final int BATCH_NUM = 1000;
    private String[] headersColumn = new String[]{"\u884c\u653f\u533a\u57df\u4ee3\u7801", "\u7c7b\u578b", "\u6dfb\u52a0\u65f6\u95f4"};

    public ExpressBlackListPageParams getParams() {
        return this.params;
    }

    public void setParams(ExpressBlackListPageParams params) {
        params.setMax(Integer.valueOf(Integer.MAX_VALUE));
        params.setOffset(Integer.valueOf(0));
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CharSink charSink = Files.asCharSink((File)this.file, (Charset)Charset.forName("GBK"), (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND});
        int count = this.expressBlackListService.queryExpressBlackListNum(this.params);
        int batch = this.getBatchs(count);
        CacheConstantseEnum constantseEnum = CacheConstantseEnum.EXPORT_EXPRESS_BLACK_LIST;
        String key = constantseEnum.getCacheKey((Object)this.taskId);
        HashOperations operations = this.redisTemplate.opsForHash();
        try {
            ArrayList headers = Lists.newArrayList((Object[])new String[]{this.joiner.join((Object[])this.headersColumn)});
            charSink.writeLines((Iterable)headers);
            OrderSnapshotToString transform = new OrderSnapshotToString();
            for (int i = 0; i < batch; ++i) {
                this.params.setOffset(Integer.valueOf(i * 1000));
                DubboResult result = this.remoteExpressBlackListService.findExpressBlackPage(this.params);
                List list = Lists.transform((List)((PagenationDto)result.getResult()).getList(), (Function)transform);
                charSink.writeLines((Iterable)list);
                operations.increment((Object)key, (Object)"successCount", (long)list.size());
            }
            operations.put((Object)key, (Object)"message", (Object)"\u6587\u4ef6\u4e0a\u4f20\u4e2d");
            String url = UploadTool.uploadOssNotCDN((File)this.file, (String)(this.filePath + this.file.getName()), (String)"application/csv;charset=GBK");
            operations.put((Object)key, (Object)"url", (Object)url);
            operations.put((Object)key, (Object)"message", (Object)"\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)LOGGER, (String)"black Export error msg={}", (Object[])new Object[]{e});
            operations.put((Object)key, (Object)"message", (Object)e.getMessage());
        }
        finally {
            operations.put((Object)key, (Object)"success", (Object)"true");
            if (this.file != null && this.file.exists() && !this.file.delete()) {
                AppLogUtil.warn((Logger)LOGGER, (String)"file delete error or file not exists");
            }
        }
    }

    private int getBatchs(int count) {
        return count % 1000 == 0 ? count / 1000 : count / 1000 + 1;
    }

    public Map<String, Object> init() {
        this.file = super.getFile(this.filePath);
        return super.init(this.file, this.taskId, CacheConstantseEnum.EXPORT_EXPRESS_BLACK_LIST);
    }

    private class OrderSnapshotToString
    implements Function<ExpressBlackListDto, String> {
        private OrderSnapshotToString() {
        }

        public String apply(ExpressBlackListDto input) {
            ArrayList row = Lists.newArrayList();
            row.add(ExpressBlackListExportRunnable.this.useForNull(input.getAddressCode()));
            row.add(ExpressBlackListExportRunnable.this.useForNull(input.getExpressCompany().getName()));
            row.add(ExpressBlackListExportRunnable.this.useForNull(DateUtils.getSecondStr((Date)input.getGmtCreate())));
            return ExpressBlackListExportRunnable.this.joiner.join((Iterable)row);
        }
    }
}

