/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.runnable.ordertaskhandler;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.NumberUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.qiho.center.api.enums.ExpressCompanyEnum;
import com.qiho.center.api.params.ExpressBlackListOperationParams;
import com.qiho.center.api.remoteservice.RemoteExpressBlackListService;
import com.qiho.manager.biz.runnable.AbstractOrderHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExpressBlackListHandler
implements AbstractOrderHandler<ExpressBlackListOperationParams> {
    private Splitter splitter = Splitter.on((String)",").trimResults().omitEmptyStrings().limit(4);
    @Autowired
    private RemoteExpressBlackListService remoteExpressBlackListService;

    @Override
    public ExpressBlackListOperationParams transform(String row, String status) {
        ExpressBlackListOperationParams params = new ExpressBlackListOperationParams();
        List list = this.splitter.splitToList((CharSequence)row);
        if (CollectionUtils.isEmpty((Collection)list) || StringUtils.isBlank((CharSequence)((CharSequence)list.get(0)))) {
            return null;
        }
        params.setBkValue((String)list.get(0));
        if (list.size() > 1) {
            params.setCompanyEnum(ExpressCompanyEnum.getByName((String)((String)list.get(1))));
        }
        if (list.size() > 2 && NumberUtils.isNumeric((String)((String)list.get(2)))) {
            params.setDataType(Integer.valueOf((String)list.get(2)));
        }
        return params;
    }

    @Override
    public ExpressBlackListOperationParams transform(String row) {
        return this.transform(row, null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<ExpressBlackListOperationParams> list) {
        return this.exeTask(cacheKey, list, (JSONObject)null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<ExpressBlackListOperationParams> list, JSONObject extraParams) {
        ArrayList relist = Lists.newArrayList();
        for (ExpressBlackListOperationParams params : list) {
            if (null == params.getCompanyEnum() || StringUtils.isBlank((CharSequence)params.getBkValue()) || null == params.getDataType()) continue;
            relist.add(params);
        }
        DubboResult result = this.remoteExpressBlackListService.batchAddExpressBlackList(cacheKey, (List)relist);
        if (result.isSuccess()) {
            return (Integer)result.getResult();
        }
        return 0;
    }
}

