/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.runnable.ordertaskhandler;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.YTOLogisticsStatusEnum;
import com.qiho.center.api.remoteservice.RemoteLogisticsOrderService;
import com.qiho.manager.biz.runnable.AbstractOrderHandler;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogisticsOrderSignHandler
implements AbstractOrderHandler<LogisticsOrderDto> {
    @Autowired
    private RemoteLogisticsOrderService remoteLogisticsOrderService;
    private static final Logger LOG = LoggerFactory.getLogger(LogisticsOrderSignHandler.class);
    private Splitter splitter = Splitter.on((String)",").trimResults().omitEmptyStrings().limit(3);

    @Override
    public LogisticsOrderDto transform(String row, String status) {
        LogisticsOrderDto params = new LogisticsOrderDto();
        try {
            List line = this.splitter.splitToList((CharSequence)row);
            if (line.size() < 2) {
                return null;
            }
            if (StringUtils.equals((String)status, (String)LogisticsOrderStatusEnum.FAILED.getCode())) {
                params.setLogisticsStatus(YTOLogisticsStatusEnum.FAILED.getDesc());
            } else if (StringUtils.equals((String)status, (String)LogisticsOrderStatusEnum.SUCCESS.getCode())) {
                params.setLogisticsStatus(YTOLogisticsStatusEnum.SIGNED.getDesc());
            } else {
                return null;
            }
            params.setLogisticsName((String)line.get(0));
            params.setPostId((String)line.get(1));
            params.setOrderStatus(status);
            return params;
        }
        catch (Exception e) {
            LOG.info("\u6279\u91cf\u8ba2\u5355\u7b7e\u6536\u6587\u4ef6\u884c\u89e3\u6790\u5931\u8d25={}", (Object)e, (Object)row);
            return null;
        }
    }

    @Override
    public LogisticsOrderDto transform(String row) {
        return this.transform(row, null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<LogisticsOrderDto> list) {
        return this.exeTask(cacheKey, list, (JSONObject)null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<LogisticsOrderDto> list, JSONObject extraParams) {
        ArrayList newList = Lists.newArrayList();
        for (LogisticsOrderDto it : list) {
            if (it == null || Objects.equal(null, (Object)it.getPostId()) || Objects.equal(null, (Object)it.getLogisticsName())) continue;
            newList.add(it);
        }
        DubboResult result = this.remoteLogisticsOrderService.batchSignOrder(cacheKey, (List)newList);
        return (Integer)result.getResult();
    }
}

