/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.runnable.ordertaskhandler;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.api.remoteservice.order.RemoteOrderService;
import com.qiho.manager.biz.runnable.AbstractOrderHandler;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderAuditHandler
implements AbstractOrderHandler<OrderAuditParams> {
    @Autowired
    private RemoteOrderService remoteOrderService;
    private Logger logger = LoggerFactory.getLogger(OrderAuditHandler.class);
    private Splitter splitter = Splitter.on((String)",").trimResults().omitEmptyStrings().limit(3);

    @Override
    public OrderAuditParams transform(String row, String status) {
        OrderAuditParams params = new OrderAuditParams();
        try {
            List line = this.splitter.splitToList((CharSequence)row);
            if (line.size() < 2) {
                return null;
            }
            Integer auditResult = Integer.valueOf((String)line.get(1));
            params.setOrderId((String)line.get(0));
            params.setAuditResult(auditResult);
            if (line.size() == 3) {
                params.setRemark((String)line.get(2));
            }
            return params;
        }
        catch (Exception e) {
            this.logger.info("\u5ba1\u6838\u8ba2\u5355\u884c\u89e3\u6790\u5931\u8d25={}", (Object)e, (Object)row);
            return null;
        }
    }

    @Override
    public OrderAuditParams transform(String row) {
        return this.transform(row, null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<OrderAuditParams> list) {
        return this.exeTask(cacheKey, list, (JSONObject)null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<OrderAuditParams> list, JSONObject extraParams) {
        ArrayList newList = Lists.newArrayList();
        for (OrderAuditParams it : list) {
            if (it == null || Objects.equal(null, (Object)it.getOrderId()) || Objects.equal(null, (Object)it.getAuditResult())) continue;
            newList.add(it);
        }
        return 0;
    }
}

