/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.ErpOrderPageParams;
import com.qiho.manager.biz.runnable.AbstractOrderHandler;
import com.qiho.manager.biz.runnable.WdtErpOrderExportRunnable;
import com.qiho.manager.biz.vo.OrderDealWithVO;
import com.qiho.manager.biz.vo.OrderTaskInfoVO;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.util.OSSFileService;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class OrderDealWithService
implements ApplicationContextAware {
    private Logger logger = LoggerFactory.getLogger(OrderDealWithService.class);
    private static final int BATCHE_NUM = 1000;
    private CacheConstantseEnum constantse = CacheConstantseEnum.DEAL_WITH_ORDER;
    private ApplicationContext applicationContext;
    @Autowired
    private OSSFileService ossFileService;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    @Resource
    private ExecutorService executorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderDealWithVO submitDealWithTask(String fileUrl, String status, Class<? extends AbstractOrderHandler> handlerClass, JSONObject extraParams) {
        OrderDealWithVO vo = new OrderDealWithVO();
        InputStream input = this.ossFileService.getOssFileInputStream(fileUrl);
        try {
            if (Objects.equal(null, (Object)input)) {
                throw new QihoException("\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            String taskId = this.createTaskId();
            int count = 0;
            String cacheKey = this.constantse.getCacheKey((Object)taskId);
            ArrayList lines = Lists.newArrayList();
            LineIterator iterator = IOUtils.lineIterator((InputStream)input, (Charset)Charset.forName("GBK"));
            AbstractOrderHandler handler = (AbstractOrderHandler)this.applicationContext.getBean(handlerClass);
            while (iterator.hasNext()) {
                String line = StringUtils.trim((String)iterator.next());
                if (StringUtils.isNotBlank((String)line)) {
                    lines.add(line);
                }
                if (lines.size() < 1000) continue;
                count += this.flush(cacheKey, lines, handler, extraParams, status).intValue();
            }
            this.redisTemplate.boundHashOps((Object)cacheKey).increment((Object)"taskCount", (count += this.flush(cacheKey, lines, handler, extraParams, status).intValue()) % 1000 == 0 ? (long)(count / 1000) : (long)(count / 1000 + 1));
            this.redisTemplate.boundHashOps((Object)cacheKey).put((Object)"count", (Object)String.valueOf(count));
            if (count == 0) {
                this.redisTemplate.boundHashOps((Object)cacheKey).put((Object)"success", (Object)"true");
            }
            this.redisTemplate.expire((Object)cacheKey, 3L, TimeUnit.HOURS);
            vo.setTaskId(taskId);
            vo.setCount(count);
        }
        catch (Exception e) {
            this.logger.error("\u8ba2\u5355\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.ossFileService.closeInputStream(input);
        }
        return vo;
    }

    public OrderDealWithVO submitDealWithTask(String fileUrl, Class<? extends AbstractOrderHandler> handlerClass) {
        return this.submitDealWithTask(fileUrl, null, handlerClass, null);
    }

    public OrderDealWithVO submitDealWithTask(String fileUrl, String status, Class<? extends AbstractOrderHandler> handlerClass) {
        return this.submitDealWithTask(fileUrl, status, handlerClass, null);
    }

    public OrderDealWithVO submitDealWithTask(String fileUrl, Class<? extends AbstractOrderHandler> handlerClass, JSONObject extraParams) {
        return this.submitDealWithTask(fileUrl, null, handlerClass, extraParams);
    }

    private <T> Integer flush(String cacheKey, List<String> lines, AbstractOrderHandler<T> handler, JSONObject extraParams, String status) {
        if (lines.isEmpty()) {
            return 0;
        }
        ArrayList list = Lists.newArrayList();
        for (String line : lines) {
            Object params = null;
            params = StringUtils.isBlank((String)status) ? (Object)handler.transform(line) : (Object)handler.transform(line, status);
            if (params == null) continue;
            list.add(params);
        }
        int total = 0;
        if (list.isEmpty()) {
            return total;
        }
        total = Objects.equal(null, (Object)extraParams) || extraParams.isEmpty() ? handler.exeTask(cacheKey, list).intValue() : handler.exeTask(cacheKey, list, extraParams).intValue();
        lines.clear();
        return total;
    }

    public JSONObject findDealWithInfo(String taskId) {
        BoundHashOperations operations = this.redisTemplate.boundHashOps((Object)taskId);
        Map info = operations.entries();
        JSONObject json = new JSONObject();
        if (!info.isEmpty()) {
            json.putAll(info);
        }
        json.put("success", (Object)json.getBoolean("success"));
        return json;
    }

    public OrderTaskInfoVO findOrderTaskInfo(String taskId) {
        BoundHashOperations operations = this.redisTemplate.boundHashOps((Object)taskId);
        Map info = operations.entries();
        if (info.isEmpty()) {
            return null;
        }
        OrderTaskInfoVO vo = new OrderTaskInfoVO();
        int handleCount = Integer.valueOf((String)info.get("handleCount"));
        int totalCount = Integer.valueOf((String)info.get("totalCount"));
        String status = (String)info.get("status");
        String failLines = (String)info.get("failLines");
        vo.setHandleCount(handleCount);
        vo.setTotalCount(totalCount);
        vo.setFailLines(failLines);
        vo.setStatus(status);
        if (status.equals("over")) {
            vo.setSuccess(true);
            this.redisTemplate.delete((Object)taskId);
        } else {
            vo.setSuccess(false);
        }
        return vo;
    }

    public String createTaskId() {
        Long taskId = new Date().getTime();
        String key = this.constantse.getCacheKey((Object)taskId);
        HashMap info = Maps.newHashMap();
        info.put("success", "false");
        info.put("count", "0");
        info.put("successCount", "0");
        info.put("failCount", "0");
        info.put("taskCount", "0");
        info.put("failIds", "");
        this.redisTemplate.opsForHash().putAll((Object)key, (Map)info);
        this.redisTemplate.expire((Object)key, 3L, TimeUnit.HOURS);
        return key;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Map<String, Object> submitOrdersExport(ErpOrderPageParams params) {
        WdtErpOrderExportRunnable runnable = (WdtErpOrderExportRunnable)this.applicationContext.getBean(WdtErpOrderExportRunnable.class);
        runnable.setParams(params);
        Map<String, Object> info = runnable.init();
        this.executorService.submit(runnable);
        return info;
    }
}

