/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.account.impl;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.account.BaiqiAccountDto;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.api.params.account.AccountPageParam;
import com.qiho.center.api.params.account.BaiqiAccountParam;
import com.qiho.center.api.remoteservice.account.RemoteBaiqiAccountBackendService;
import com.qiho.center.api.remoteservice.agent.RemoteBaiqiAgentBackendService;
import com.qiho.center.api.remoteservice.merchant.RemoteMerchantService;
import com.qiho.manager.biz.params.MainAccountParam;
import com.qiho.manager.biz.service.account.BaiqiAccountService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.account.IdAndNameVO;
import com.qiho.manager.biz.vo.account.MainAccountVO;
import com.qiho.manager.common.util.Md5Util;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="baiqiMainAccountService")
public class BaiqiAccountServiceImpl
implements BaiqiAccountService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaiqiAccountServiceImpl.class);
    @Resource
    private RemoteBaiqiAccountBackendService remoteBaiqiAccountBackendService;
    @Resource
    private RemoteMerchantService remoteMerchantService;
    @Resource
    private RemoteBaiqiAgentBackendService remoteBaiqiAgentBackendService;
    @Autowired
    private AdminPowerCacheService adminPowerCacheService;

    @Override
    public List<IdAndNameVO> findRelationIdAndName(int accountType) {
        List idAndNameDtos = null;
        idAndNameDtos = accountType == BaiqiAccountTypeEnum.MAIN_ACCOUNT.getCode() ? this.remoteMerchantService.findAllIdAndNames() : this.remoteBaiqiAgentBackendService.findAgentIdAndName();
        return idAndNameDtos.stream().map(temp -> {
            IdAndNameVO idAndNameVO = new IdAndNameVO();
            idAndNameVO.setId(temp.getId());
            idAndNameVO.setName(temp.getName());
            return idAndNameVO;
        }).collect(Collectors.toList());
    }

    @Override
    public Pagenation<MainAccountVO> findPageAccount(AccountPageParam pageQueryParams) {
        this.buildPermissionParam(pageQueryParams);
        PagenationDto pagenationDto = this.remoteBaiqiAccountBackendService.findPageMainAccount(pageQueryParams);
        Pagenation<MainAccountVO> page = new Pagenation<MainAccountVO>();
        List list = pagenationDto.getList();
        page.setTotal(pagenationDto.getTotal());
        if (CollectionUtils.isEmpty((Collection)list)) {
            page.setList(Collections.emptyList());
            return page;
        }
        page.setList(BeanUtils.copyList((List)pagenationDto.getList(), MainAccountVO.class));
        return page;
    }

    private void buildPermissionParam(AccountPageParam pageQueryParams) {
        boolean flag;
        Boolean seeAllMerchant = this.adminPowerCacheService.hasPower(RequestTool.getAdminId(), "seeAllAgent");
        if (!seeAllMerchant.booleanValue()) {
            pageQueryParams.setOwnerAeName(RequestTool.getAdmin().getName());
        }
        if (!(flag = this.adminPowerCacheService.hasPower(RequestTool.getAdminId(), "seeAllMerchant").booleanValue())) {
            pageQueryParams.setOwnerAeId(RequestTool.getAdminId());
        }
    }

    @Override
    public String inserAccount(MainAccountParam mainAccountParam) {
        Boolean result;
        BaiqiAccountDto accountDto = (BaiqiAccountDto)BeanUtils.copy((Object)mainAccountParam, BaiqiAccountDto.class);
        try {
            result = this.remoteBaiqiAccountBackendService.insertMainAccount(accountDto);
        }
        catch (Exception e) {
            LOGGER.warn("\u65b0\u589e\u4e3b\u8d26\u53f7\u5931\u8d25,msg={}", (Object)e.getMessage());
            return e.getMessage();
        }
        if (result.booleanValue()) {
            return "";
        }
        return "\u65b0\u589e\u4e3b\u8d26\u53f7\u5931\u8d25";
    }

    @Override
    public String updateAccount(Long id, String mobile, String pwd) {
        Boolean result;
        BaiqiAccountParam accountParam = new BaiqiAccountParam();
        accountParam.setId(id);
        accountParam.setMobile(mobile);
        if (!pwd.equals("BAIqi123")) {
            accountParam.setPwd(Md5Util.md5WithSalt((String)pwd, (String)"@#$_BAIqi&$#@"));
        }
        try {
            result = this.remoteBaiqiAccountBackendService.updateMainAccount(accountParam);
        }
        catch (Exception e) {
            LOGGER.warn("\u66f4\u65b0\u4e3b\u8d26\u53f7\u5931\u8d25,msg={}", (Object)e.getMessage());
            return e.getMessage();
        }
        if (result.booleanValue()) {
            return "";
        }
        return "\u66f4\u65b0\u4e3b\u8d26\u53f7\u5931\u8d25";
    }

    @Override
    public String changeAccountState(Long id, boolean state) {
        Boolean result;
        try {
            result = state ? this.remoteBaiqiAccountBackendService.enableMainAccount(id) : this.remoteBaiqiAccountBackendService.disableMainAccount(id);
        }
        catch (Exception e) {
            LOGGER.warn("\u66f4\u65b0\u72b6\u6001\u5931\u8d25,msg={}", (Object)e.getMessage());
            return e.getMessage();
        }
        if (result.booleanValue()) {
            return "";
        }
        return "\u66f4\u65b0\u4e3b\u8d26\u53f7\u72b6\u6001\u5931\u8d25";
    }
}

