/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.advert.impl;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ConfigDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.advert.BaiqiItemAdvertDto;
import com.qiho.center.api.dto.advert.DefaultItemAdvertDto;
import com.qiho.center.api.enums.EnableStatusEnum;
import com.qiho.center.api.params.ConfigParams;
import com.qiho.center.api.params.advert.ItemAdvertQueryParams;
import com.qiho.center.api.remoteservice.RemoteConfigService;
import com.qiho.center.api.remoteservice.advert.RemoteItemAdvertService;
import com.qiho.manager.biz.params.advert.DefaultItemAdvertParam;
import com.qiho.manager.biz.params.advert.ItemAdvertSaveParam;
import com.qiho.manager.biz.service.advert.ItemAdvertService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.advert.DefaultItemAdvertVO;
import com.qiho.manager.biz.vo.advert.ItemAdvertVO;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.param.PageParam;
import com.qiho.manager.common.util.AssertUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemAdvertServiceImpl
implements ItemAdvertService {
    @Autowired
    private RemoteItemAdvertService remoteItemAdvertService;
    @Autowired
    private RemoteConfigService remoteConfigService;

    @Override
    public Pagenation<ItemAdvertVO> queryPage(PageParam param) {
        ItemAdvertQueryParams queryParams = new ItemAdvertQueryParams();
        queryParams.setOffset(Integer.valueOf((param.getPageNum() - 1) * param.getPageSize()));
        queryParams.setMax(param.getPageSize());
        PagenationDto pageDto = this.remoteItemAdvertService.queryPage(queryParams);
        Pagenation<ItemAdvertVO> page = new Pagenation<ItemAdvertVO>();
        page.setTotal(pageDto.getTotal());
        if (pageDto.getTotal() == 0) {
            return page.emptyPage();
        }
        page.setList(this.convertVOList(pageDto.getList()));
        return page;
    }

    @Override
    public Boolean saveItemAdvert(ItemAdvertSaveParam param) {
        if (param.getId() == null) {
            return this.createItemAdvert(param);
        }
        return this.updateItemAdvert(param);
    }

    @Override
    public Boolean deleteItemAdvert(Long id) {
        ResultDto resultDto = this.remoteItemAdvertService.deleteById(id);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        if (!((Boolean)resultDto.getResult()).booleanValue()) {
            throw new QihoManagerException("\u5220\u9664\u5546\u54c1\u5e7f\u544a\u4f4d\u5931\u8d25");
        }
        return true;
    }

    @Override
    public Boolean alterAdvertStatus(Long id, Boolean advertStatus) {
        BaiqiItemAdvertDto dto = new BaiqiItemAdvertDto();
        dto.setId(id);
        dto.setAdvertStatus(advertStatus);
        dto.setOpeartor(RequestTool.getAdmin().getName());
        ResultDto resultDto = this.remoteItemAdvertService.alterAdvertStatus(dto);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        if (!((Boolean)resultDto.getResult()).booleanValue()) {
            throw new QihoManagerException("\u4fee\u6539\u5546\u54c1\u5e7f\u544a\u4f4d\u72b6\u6001\u5931\u8d25");
        }
        return true;
    }

    @Override
    public Boolean saveDefaultConfig(DefaultItemAdvertParam param) {
        DefaultItemAdvertDto dto = (DefaultItemAdvertDto)BeanUtils.copy((Object)param, DefaultItemAdvertDto.class);
        ConfigParams configParams = new ConfigParams();
        configParams.setConfigName("DEFAULT_ITEM_ADVERT");
        configParams.setConfigValue(JSONObject.toJSONString((Object)dto));
        ResultDto resultDto = this.remoteConfigService.insertOrUpdateConfig(configParams);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        return true;
    }

    @Override
    public String findAroundUrl() {
        ConfigDto configDto = this.remoteConfigService.fetchConfigByName("KEEP_AROUND_URL");
        if (configDto == null) {
            return null;
        }
        return configDto.getConfigValue();
    }

    @Override
    public Boolean saveAroundUrl(String url) {
        AssertUtil.stringNotBlank((String)url, (String)"\u7ee7\u7eed\u901b\u901bUrl\u4e0d\u80fd\u4e3a\u7a7a");
        url = StringEscapeUtils.unescapeHtml4((String)url);
        ConfigParams configParams = new ConfigParams();
        configParams.setConfigName("KEEP_AROUND_URL");
        configParams.setConfigValue(url.trim());
        ResultDto resultDto = this.remoteConfigService.insertOrUpdateConfig(configParams);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        return true;
    }

    @Override
    public DefaultItemAdvertVO findDefualtItemAdvert() {
        ConfigDto configDto = this.remoteConfigService.fetchConfigByName("DEFAULT_ITEM_ADVERT");
        if (configDto == null) {
            return null;
        }
        DefaultItemAdvertDto dto = (DefaultItemAdvertDto)JSON.parseObject((String)configDto.getConfigValue(), DefaultItemAdvertDto.class);
        return (DefaultItemAdvertVO)BeanUtils.copy((Object)dto, DefaultItemAdvertVO.class);
    }

    private Boolean createItemAdvert(ItemAdvertSaveParam param) {
        AssertUtil.numericIsPositive((Long)param.getItemId(), (String)"\u5546\u54c1id\u4e0d\u5408\u6cd5");
        if (param.getAdvertId() != null && param.getAdvertId() < 1L) {
            throw new QihoManagerException("\u5e7f\u544a\u4f4did\u4e0d\u5408\u6cd5");
        }
        BaiqiItemAdvertDto dto = new BaiqiItemAdvertDto();
        dto.setItemId(param.getItemId());
        dto.setAdvertId(param.getAdvertId());
        dto.setAdvertStatus(Boolean.valueOf(EnableStatusEnum.OFF.isStatus()));
        dto.setOpeartor(RequestTool.getAdmin().getName());
        ResultDto resultDto = this.remoteItemAdvertService.insertItemAdvert(dto);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        return true;
    }

    private Boolean updateItemAdvert(ItemAdvertSaveParam param) {
        if (param.getAdvertId() != null && param.getAdvertId() < 1L) {
            throw new QihoManagerException("\u5e7f\u544a\u4f4did\u4e0d\u5408\u6cd5");
        }
        BaiqiItemAdvertDto dto = new BaiqiItemAdvertDto();
        dto.setId(param.getId());
        dto.setItemId(param.getItemId());
        dto.setAdvertId(param.getAdvertId());
        dto.setOpeartor(RequestTool.getAdmin().getName());
        ResultDto resultDto = this.remoteItemAdvertService.updateItemAdvert(dto);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        if (!((Boolean)resultDto.getResult()).booleanValue()) {
            throw new QihoManagerException("\u66f4\u65b0\u5546\u54c1\u5e7f\u544a\u4f4d\u5931\u8d25");
        }
        return true;
    }

    private List<ItemAdvertVO> convertVOList(List<BaiqiItemAdvertDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return Lists.newArrayList();
        }
        ArrayList<ItemAdvertVO> list = new ArrayList<ItemAdvertVO>();
        dtoList.forEach(e -> {
            ItemAdvertVO vo = (ItemAdvertVO)BeanUtils.copy((Object)e, ItemAdvertVO.class);
            vo.setItemId(e.getItemId() == 0L ? "\u9ed8\u8ba4" : String.valueOf(e.getItemId()));
            list.add(vo);
        });
        return list;
    }
}

