/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.AbTestSkuDto;
import com.qiho.center.api.dto.ItemSkuDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.TestMetadataQueryParam;
import com.qiho.center.api.remoteservice.RemoteAbTestSkuService;
import com.qiho.center.api.remoteservice.item.RemoteItemSkuService;
import com.qiho.manager.biz.service.AbTestSkuService;
import com.qiho.manager.biz.vo.AbTestSkuVO;
import com.qiho.manager.biz.vo.ItemSkuVO;
import com.qiho.manager.biz.vo.Pagenation;
import java.text.DecimalFormat;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AbTestSkuServiceImpl
implements AbTestSkuService {
    @Autowired
    RemoteItemSkuService remoteItemSkuService;
    @Autowired
    RemoteAbTestSkuService remoteAbTestSkuService;

    @Override
    public List<ItemSkuVO> getSkuByItemId(Long itemId) {
        List list = this.remoteItemSkuService.getSkuByItemId(itemId);
        return BeanUtils.copyList((List)list, ItemSkuVO.class);
    }

    @Override
    public void save(AbTestSkuDto abTestSkuDto, List<ItemSkuDto> skus) throws BizException {
        this.remoteAbTestSkuService.save(skus, abTestSkuDto);
    }

    @Override
    public void delete(Long id) throws BizException {
        this.remoteAbTestSkuService.delete(id);
    }

    @Override
    public Pagenation<AbTestSkuVO> queryList(TestMetadataQueryParam testMetadataQueryParam) throws BizException {
        PagenationDto pagenation = this.remoteAbTestSkuService.queryList(testMetadataQueryParam);
        Pagenation<AbTestSkuVO> resultPage = new Pagenation<AbTestSkuVO>();
        resultPage.setTotal(pagenation.getTotal());
        List resultList = BeanUtils.copyList((List)pagenation.getList(), AbTestSkuVO.class);
        for (AbTestSkuVO abTestSkuVO : resultList) {
            List<ItemSkuDto> skus = abTestSkuVO.getSkus();
            if (CollectionUtils.isEmpty(skus)) continue;
            Integer minPrice = Integer.MAX_VALUE;
            Integer maxPrice = 0;
            for (ItemSkuDto dto : skus) {
                if (dto.getSellingPrice() > maxPrice) {
                    maxPrice = dto.getSellingPrice();
                }
                if (dto.getSellingPrice() >= minPrice) continue;
                minPrice = dto.getSellingPrice();
            }
            DecimalFormat df = new DecimalFormat("0.00");
            if (maxPrice.equals(minPrice)) {
                abTestSkuVO.setPriceRange(df.format((float)maxPrice.intValue() / 100.0f));
                continue;
            }
            abTestSkuVO.setPriceRange(df.format((float)minPrice.intValue() / 100.0f) + "~" + df.format((float)maxPrice.intValue() / 100.0f));
        }
        resultPage.setList(resultList);
        return resultPage;
    }

    @Override
    public AbTestSkuVO queryDetail(Long id) throws BizException {
        AbTestSkuDto dto = this.remoteAbTestSkuService.queryDetail(id);
        return (AbTestSkuVO)BeanUtils.copy((Object)dto, AbTestSkuVO.class);
    }

    @Override
    public void syncToItemSku(Long id, Long userId) throws BizException {
        this.remoteAbTestSkuService.syncToItemSku(id, userId);
    }
}

