/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.params.ExpressBlackListPageParams;
import com.qiho.center.api.remoteservice.RemoteExpressBlackListService;
import com.qiho.manager.biz.runnable.ordertaskhandler.ExpressBlackListExportRunnable;
import com.qiho.manager.biz.service.ExpressBlackService;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ExpressBlackListServiceImpl
implements ExpressBlackService,
ApplicationContextAware {
    @Autowired
    private RemoteExpressBlackListService remoteExpressBlackListService;
    @Autowired
    private ApplicationContext applicationContext;
    @Resource
    private ExecutorService executorService;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;

    @Override
    public int queryExpressBlackListNum(ExpressBlackListPageParams params) {
        DubboResult result = this.remoteExpressBlackListService.finaExpressBlackNum(params);
        if (result.isSuccess()) {
            return (Integer)result.getResult();
        }
        return 0;
    }

    @Override
    public Map<String, Object> submitExpressBlackPageExport(ExpressBlackListPageParams params) {
        ExpressBlackListExportRunnable runnable = (ExpressBlackListExportRunnable)this.applicationContext.getBean(ExpressBlackListExportRunnable.class);
        runnable.setParams(params);
        Map<String, Object> info = runnable.init();
        this.executorService.submit(runnable);
        return info;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public JSONObject queryExpressBlackExportStatus(String taskId) {
        CacheConstantseEnum constantseEnum = CacheConstantseEnum.EXPORT_EXPRESS_BLACK_LIST;
        String cacheKey = constantseEnum.getCacheKey((Object)taskId);
        BoundHashOperations operations = this.redisTemplate.boundHashOps((Object)cacheKey);
        Map info = operations.entries();
        JSONObject json = new JSONObject();
        if (info.isEmpty()) {
            json.put("success", (Object)true);
        } else {
            json.putAll(info);
            if (json.getBoolean("success").booleanValue()) {
                this.redisTemplate.delete((Object)cacheKey);
            }
        }
        json.put("success", (Object)json.getBoolean("success"));
        return json;
    }
}

