/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ItemAdvertDto;
import com.qiho.center.api.dto.ItemDetailDto;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.ItemSkuDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.DeliveryEnum;
import com.qiho.center.api.enums.ItemStatusEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.remoteservice.RemoteItemService;
import com.qiho.center.api.remoteservice.RemoteRecommendItemService;
import com.qiho.center.api.remoteservice.merchant.RemoteItemMerchantService;
import com.qiho.center.api.remoteservice.tag.RemoteTagService;
import com.qiho.manager.biz.params.ItemAdvertParam;
import com.qiho.manager.biz.service.ItemService;
import com.qiho.manager.biz.vo.ItemAdvertVo;
import com.qiho.manager.biz.vo.ItemDetailVO;
import com.qiho.manager.biz.vo.ItemImgVO;
import com.qiho.manager.biz.vo.ItemSkuVO;
import com.qiho.manager.biz.vo.ItemVO;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.SkuPropertyVO;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.constant.DomainConstantUtil;
import com.qiho.manager.common.exception.QihoManagerException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemServiceImpl
implements ItemService {
    private static final Integer DEFAULT_LIMIT_NUMBER = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemServiceImpl.class);
    @Autowired
    private RemoteItemService remoteItemService;
    @Autowired
    private RemoteAdminService remoteAdminService;
    @Autowired
    private RemoteRecommendItemService remoteRecommendItemService;
    @Autowired
    private RemoteItemMerchantService remoteItemMerchantService;
    @Autowired
    private RemoteTagService remoteTagService;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;
    @Autowired
    private AdminPowerCacheService adminPowerCacheService;

    @Override
    public Pagenation<ItemVO> queryList(ItemDto queryItem, Integer pageNum, Integer pageSize) {
        boolean flag = this.adminPowerCacheService.hasPower(RequestTool.getAdminId(), "seeAllMerchant");
        Long ownerId = flag ? null : RequestTool.getAdminId();
        DubboResult result = this.remoteItemService.queryItemPage(queryItem, ownerId, pageNum, pageSize);
        PagenationDto pageDto = (PagenationDto)result.getResult();
        List itemDtoList = pageDto.getList();
        Pagenation<ItemVO> page = new Pagenation<ItemVO>();
        page.setTotal(pageDto.getTotal());
        List<ItemVO> itemVOList = this.transformItemVO(itemDtoList);
        page.setList(itemVOList);
        return page;
    }

    @Override
    public ItemDetailVO queryItemDetail(Long itemId) {
        DubboResult result = this.remoteItemService.queryItemDetail(itemId);
        ItemDetailDto itemDetailDto = (ItemDetailDto)result.getResult();
        ItemDetailVO itemDetailVO = (ItemDetailVO)BeanUtils.copy((Object)result.getResult(), ItemDetailVO.class);
        itemDetailVO.setTopCategoryName(itemDetailDto.getExtParamValue("topCategoryName"));
        itemDetailVO.setCategoryIdList((List)JSON.parseObject((String)itemDetailDto.getExtParamValue("categoryIdList"), (TypeReference)new TypeReference<List<Long>>(){}, (Feature[])new Feature[0]));
        itemDetailVO.setCountDownCycle(itemDetailDto.getExtParamValue("countDownCycle"));
        itemDetailVO.setCountDownLimit(itemDetailDto.getExtParamValue("countDownLimit"));
        if (itemDetailDto.getMerchantDto() != null) {
            itemDetailVO.setMerchantId(itemDetailDto.getMerchantDto().getId());
            itemDetailVO.setMerchantDelivery(DeliveryEnum.getByCode((String)itemDetailDto.getDelivery()).getDesc());
            itemDetailVO.setMerchantName(itemDetailDto.getMerchantDto().getMerchantName());
        }
        itemDetailVO.setImage(itemDetailDto.getExtParamValue("image"));
        if (itemDetailDto.getExtParamValue("limitNumber") == null) {
            itemDetailVO.setLimitNumber(DEFAULT_LIMIT_NUMBER);
        } else {
            itemDetailVO.setLimitNumber(Integer.valueOf(itemDetailDto.getExtParamValue("limitNumber")));
        }
        if (StringUtils.isBlank((CharSequence)itemDetailDto.getExtParamValue("imgHeight"))) {
            itemDetailVO.setImgHeight(Lists.newArrayList());
        } else {
            List imgHeightList = JSON.parseArray((String)itemDetailDto.getExtParamValue("imgHeight"), ItemImgVO.class);
            itemDetailVO.setImgHeight(imgHeightList);
        }
        itemDetailVO.setMainImgUrl(itemDetailDto.getExtParamValue("mainImgUrl"));
        itemDetailVO.setItemIntroduce(itemDetailDto.getExtParamValue("itemIntroduce"));
        itemDetailVO.setSaleLableUrl(itemDetailDto.getExtParamValue("saleLableUrl"));
        String supportCOD = itemDetailDto.getExtParamValue("supportCOD");
        itemDetailVO.setSupportCOD(StringUtils.isBlank((CharSequence)supportCOD) || StringUtils.equals((CharSequence)StringUtils.trimToNull((String)supportCOD), (CharSequence)"1") ? Boolean.TRUE : Boolean.FALSE);
        itemDetailVO.setSkuList(this.converToItemSkuVO(itemDetailDto.getSkuList()));
        itemDetailVO.setSkuProperties(BeanUtils.copyList((List)itemDetailDto.getSkuPropertyList(), SkuPropertyVO.class));
        itemDetailVO.setGmtModified(DateUtils.getSecondStr((Date)itemDetailDto.getGmtModified()));
        try {
            AdminDto admin = this.remoteAdminService.findOneAdmin(itemDetailDto.getGmtModifier());
            itemDetailVO.setGmtModifyEmail(admin.getEmail());
            itemDetailVO.setGmtModifyName(admin.getName());
        }
        catch (Exception e) {
            LOGGER.warn("\u83b7\u53d6\u7ba1\u7406\u5458\u5f02\u5e38\uff0citemId: {} ", (Object)itemId, (Object)e);
            itemDetailVO.setGmtModifyEmail("");
            itemDetailVO.setGmtModifyName("");
        }
        itemDetailVO.setMainRecomIds(itemDetailDto.getExtParamValue("mainRecommendItemId"));
        return itemDetailVO;
    }

    private List<ItemSkuVO> converToItemSkuVO(List<ItemSkuDto> list) {
        ArrayList voList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return voList;
        }
        for (ItemSkuDto dto : list) {
            ItemSkuVO vo = (ItemSkuVO)BeanUtils.copy((Object)dto, ItemSkuVO.class);
            vo.setStockId(dto.getStockId().toString());
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public Long saveItem(ItemDetailDto itemDetailDto) {
        Long itemId = itemDetailDto.getId();
        itemDetailDto.setGmtModifier(RequestTool.getAdminId());
        if (itemId == null) {
            itemDetailDto.setGmtCreator(RequestTool.getAdminId());
            DubboResult result = this.remoteItemService.createItem(itemDetailDto);
            if (!result.isSuccess()) {
                throw new QihoException(result.getMsg());
            }
            itemId = (Long)result.getResult();
        } else {
            DubboResult result = this.remoteItemService.updateItem(itemDetailDto);
            if (!result.isSuccess()) {
                throw new QihoException(result.getMsg());
            }
            String key = CacheConstantseEnum.ITEM_ID + itemId.toString();
            this.advancedCacheClient.remove(key);
        }
        return itemId;
    }

    @Override
    public void updateStatusBatch(List<Long> itemIdList, String status, Long gmtModifier) {
        this.remoteItemService.updateStatus(itemIdList, status, gmtModifier);
    }

    @Override
    public void deleteBatch(List<Long> itemIdList, Long gmtModifier) {
        this.remoteItemService.deleteBatch(itemIdList, gmtModifier);
        this.remoteItemMerchantService.deleteBatchByItemId(itemIdList, gmtModifier);
    }

    @Override
    public void recommendBatch(List<Long> itemIdList) {
        this.remoteRecommendItemService.recommendBatch(itemIdList);
    }

    @Override
    public List<ItemVO> transformItemVO(List<ItemDto> itemDtos) {
        return Lists.transform(itemDtos, itemDto -> {
            ItemVO itemVO = (ItemVO)BeanUtils.copy((Object)itemDto, ItemVO.class);
            itemVO.setTopCategoryName(itemDto.getExtParamValue("topCategoryName"));
            itemVO.setImage(itemDto.getExtParamValue("image"));
            itemVO.setUrl(DomainConstantUtil.getQihoWebUrl() + "/item/detail?id=" + itemDto.getId());
            return itemVO;
        });
    }

    @Override
    public List<ItemVO> querySimpleList(ItemDto itemDto) {
        if (StringUtils.isEmpty((CharSequence)itemDto.getItemStatus())) {
            itemDto.setItemStatus(ItemStatusEnum.STATUS_ON.getCode());
        }
        DubboResult result = this.remoteItemService.queryItemSimpleList(itemDto);
        List dtoList = (List)result.getResult();
        return BeanUtils.copyList((List)dtoList, ItemVO.class);
    }

    @Override
    public Boolean updateItemAdvertIdsAndthreshold(ItemAdvertParam param) {
        DubboResult resultDto = this.remoteItemService.queryExtParamByItemId(param.getItemId());
        if (!resultDto.isSuccess() || null == resultDto.getResult()) {
            throw new QihoManagerException("itemId \u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u6269\u5c55\u4fe1\u606f");
        }
        ItemAdvertDto itemAdvertDto = (ItemAdvertDto)resultDto.getResult();
        String extParamStr = itemAdvertDto.getExtParam();
        JSONObject extJson = JSONObject.parseObject((String)extParamStr);
        if (null == extJson) {
            extJson = new JSONObject();
        }
        extJson.put("advertIds", (Object)param.getAdvertIds());
        extJson.put("threshold", (Object)param.getThreshold());
        itemAdvertDto.setExtParam(extJson.toJSONString());
        DubboResult resultBase = this.remoteItemService.updateExtParamByItemId(itemAdvertDto);
        return resultBase.isSuccess() && (Boolean)resultBase.getResult() != false;
    }

    @Override
    public ItemAdvertVo queryItemAdvertByItemId(Long itemId) {
        ItemAdvertVo itemAdvertVo = new ItemAdvertVo();
        itemAdvertVo.setItemId(itemId);
        DubboResult result = this.remoteItemService.queryExtParamByItemId(itemId);
        if (!result.isSuccess() || null == result.getResult()) {
            return itemAdvertVo;
        }
        ItemAdvertDto dto = (ItemAdvertDto)result.getResult();
        JSONObject extJson = JSONObject.parseObject((String)dto.getExtParam());
        if (null == extJson) {
            return itemAdvertVo;
        }
        itemAdvertVo.setAdvertIds(extJson.getString("advertIds"));
        itemAdvertVo.setThreshold(extJson.getString("threshold"));
        return itemAdvertVo;
    }

    @Override
    public ItemAdvertDto queryExtParamByItemId(Long itemId) {
        DubboResult dubboResult = this.remoteItemService.queryExtParamByItemId(itemId);
        if (dubboResult.isSuccess() && null != dubboResult.getResult()) {
            return (ItemAdvertDto)dubboResult.getResult();
        }
        return new ItemAdvertDto();
    }

    @Override
    public Boolean updateExtParamByItemId(Long itemId, Map<String, String> extParam) {
        DubboResult dubboResult = this.remoteItemService.queryExtParamByItemId(itemId);
        if (!dubboResult.isSuccess() || null == dubboResult.getResult()) {
            throw new QihoException("\u67e5\u8be2\u4e0d\u5230\u9700\u8981\u66f4\u65b0\u7684\u5546\u54c1\u7684\u914d\u7f6e");
        }
        String extParamStr = ((ItemAdvertDto)dubboResult.getResult()).getExtParam();
        JSONObject extJson = JSONObject.parseObject((String)extParamStr);
        if (null == extJson) {
            extJson = new JSONObject();
        }
        for (Map.Entry<String, String> entry : extParam.entrySet()) {
            extJson.put(entry.getKey(), (Object)entry.getValue());
        }
        ItemAdvertDto updateParam = new ItemAdvertDto();
        updateParam.setItemId(itemId);
        updateParam.setExtParam(extJson.toJSONString());
        this.remoteItemService.updateExtParamByItemId(updateParam);
        this.remoteItemService.updateVirtailStock(itemId);
        return Boolean.TRUE;
    }

    @Override
    public List<ItemVO> queryItemsByItemIds(List<Long> itemIdList) {
        List itemDtoList = this.remoteItemService.queryItemsByItemIds(itemIdList);
        return BeanUtils.copyList((List)itemDtoList, ItemVO.class);
    }
}

