/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.params.MonitorReportQueryParam;
import com.qiho.center.api.remoteservice.monitor.RemoteMonitorReportService;
import com.qiho.manager.biz.runnable.MonitorReportExportRunnable;
import com.qiho.manager.biz.service.LogisticsMonitorReportService;
import com.qiho.manager.biz.service.logistics.LogisticsService;
import com.qiho.manager.biz.vo.monitor.LogisticsMonitorReportVO;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.exception.QihoManagerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class LogisticsMonitorReportServiceImpl
implements LogisticsMonitorReportService,
ApplicationContextAware {
    @Autowired
    private ApplicationContext applicationContext;
    @Resource
    private ExecutorService executorService;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    @Resource
    private RemoteMonitorReportService remoteMonitorReportService;
    @Resource
    private LogisticsService logisticsService;

    @Override
    public List<LogisticsMonitorReportVO> queryList(MonitorReportQueryParam param) {
        List dtoList = this.remoteMonitorReportService.queryList(param);
        if (CollectionUtils.isEmpty((Collection)dtoList)) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        Map<String, String> logisticsMap = this.logisticsService.getBaiqiLogisticsCodeToName();
        dtoList.forEach(dto -> {
            LogisticsMonitorReportVO vo = (LogisticsMonitorReportVO)BeanUtils.copy((Object)dto, LogisticsMonitorReportVO.class);
            vo.setLogisticsName((String)logisticsMap.get(dto.getLogisticsCode()));
            vo.setWarehouseName("\u5bcc\u9633\u4ed3\u5e93");
            if (StringUtils.equals((CharSequence)dto.getMonitorStatus(), (CharSequence)OrderStatusEnum.TO_SEND.getCode())) {
                vo.setMonitorStatusName(OrderStatusEnum.TO_SEND.getDesc());
            } else {
                vo.setMonitorStatusName(LogisticsOrderStatusEnum.getByCode((String)dto.getMonitorStatus()).getDesc());
            }
            list.add(vo);
        });
        return list;
    }

    @Override
    public Map<String, Object> exportList(MonitorReportQueryParam param) {
        List result = this.remoteMonitorReportService.queryList(param);
        int count = result.size();
        if (count <= 0) {
            throw new QihoManagerException("\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u8bb0\u5f55");
        }
        MonitorReportExportRunnable runnable = (MonitorReportExportRunnable)this.applicationContext.getBean(MonitorReportExportRunnable.class);
        runnable.setQueryParam(param);
        Map<String, Object> info = runnable.init();
        info.put("count", count);
        this.executorService.submit(runnable);
        return info;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public JSONObject queryExpressBlackExportStatus(String taskId) {
        CacheConstantseEnum constantseEnum = CacheConstantseEnum.EXPORT_MONITOR_REPORT;
        String cacheKey = constantseEnum.getCacheKey((Object)taskId);
        BoundHashOperations operations = this.redisTemplate.boundHashOps((Object)cacheKey);
        Map info = operations.entries();
        JSONObject json = new JSONObject();
        if (info.isEmpty()) {
            json.put("success", (Object)true);
        } else {
            json.putAll(info);
        }
        json.put("success", (Object)json.getBoolean("success"));
        return json;
    }
}

