/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.dto.logistics.LogisticsProcessDto;
import com.qiho.center.api.dto.logistics.QueryLogisticsOrderDto;
import com.qiho.center.api.dto.logistics.QueryTYOLogisticsMsgDto;
import com.qiho.center.api.enums.ExpressCompanyEnum;
import com.qiho.center.api.enums.LogisticsNameEnum;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.YTOErrorCodeReturnEnum;
import com.qiho.center.api.enums.YTOLogisticsStatusEnum;
import com.qiho.center.api.remoteservice.RemoteLogisticsOrderService;
import com.qiho.manager.biz.params.BatchAuditOrderParam;
import com.qiho.manager.biz.runnable.DistributeOrderExportRunnable;
import com.qiho.manager.biz.runnable.ordertaskhandler.LogisticsOrderSignHandler;
import com.qiho.manager.biz.service.LogisticsOrderService;
import com.qiho.manager.biz.service.OrderDealWithService;
import com.qiho.manager.biz.vo.OrderDealWithVO;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.logistics.LogisticsOrderVO;
import com.qiho.manager.biz.vo.logistics.YTOLogisticsReturnVO;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.constant.YTOInterfaceUtil;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.util.AppLogUtil;
import com.qiho.manager.common.util.Environment;
import com.qiho.manager.common.util.JaxbUtil;
import com.qiho.manager.common.util.MessageDigestUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class LogisticsOrderServiceImpl
implements LogisticsOrderService,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(LogisticsOrderServiceImpl.class);
    @Autowired
    private RemoteLogisticsOrderService remoteLogisticsOrderService;
    @Autowired
    private OrderDealWithService orderDealWithService;
    @Autowired
    private ApplicationContext applicationContext;
    @Resource
    private ExecutorService executorService;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    private static final String DELIVER_NAME = "deliverName";
    private static final String CONTACT_INFO = "contactInfo";

    @Override
    public Pagenation<LogisticsOrderVO> queryList(QueryLogisticsOrderDto queryItem, Integer pageNum, Integer pageSize) {
        DubboResult result = this.remoteLogisticsOrderService.queryLogisticsOrderPage(queryItem, pageNum, pageSize);
        PagenationDto pageDto = (PagenationDto)result.getResult();
        List logisticsOrderDtoList = pageDto.getList();
        Pagenation<LogisticsOrderVO> page = new Pagenation<LogisticsOrderVO>();
        page.setTotal(pageDto.getTotal());
        List<LogisticsOrderVO> logisticsOrderVOList = this.transformLogisticsOrderVO(logisticsOrderDtoList);
        page.setList(logisticsOrderVOList);
        return page;
    }

    private List<LogisticsOrderVO> transformLogisticsOrderVO(List<LogisticsOrderDto> logisticsOrderDtoList) {
        ArrayList logisticsOrderVOList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(logisticsOrderDtoList)) {
            return logisticsOrderVOList;
        }
        for (LogisticsOrderDto dto : logisticsOrderDtoList) {
            LogisticsOrderVO vo = (LogisticsOrderVO)BeanUtils.copy((Object)dto, LogisticsOrderVO.class);
            vo.setGmtCreate(DateUtils.getSecondStr((Date)dto.getGmtCreate()));
            vo.setGmtModified(DateUtils.getSecondStr((Date)dto.getGmtModified()));
            LogisticsOrderStatusEnum statusEnum = LogisticsOrderStatusEnum.getByCode((String)dto.getOrderStatus());
            if (Objects.isNull(statusEnum)) {
                vo.setOrderStatus(dto.getOrderStatus());
            } else {
                vo.setOrderStatus(statusEnum.getDesc());
            }
            vo.setOrderStatusModified(DateUtils.getSecondStr((Date)dto.getOrderStatusModified()));
            logisticsOrderVOList.add(vo);
        }
        return logisticsOrderVOList;
    }

    @Override
    public Integer updateLogisticsOrderStatus(String logisticsId, String orderStatus) {
        DubboResult result = this.remoteLogisticsOrderService.updateBylogisticsId(logisticsId, orderStatus);
        return (Integer)result.getResult();
    }

    @Override
    public YTOLogisticsReturnVO ytoLogisticsMsg(String logisticsInterface, String dataDigest, String clientId, String type) {
        YTOLogisticsReturnVO ytoLogisticsReturnVO = new YTOLogisticsReturnVO(ExpressCompanyEnum.YTO.getCode());
        String newLogisticsInterface = StringEscapeUtils.unescapeHtml3((String)logisticsInterface);
        AppLogUtil.info((Logger)LOG, (String)newLogisticsInterface);
        QueryTYOLogisticsMsgDto dto = (QueryTYOLogisticsMsgDto)JaxbUtil.converyToJavaBean((String)newLogisticsInterface, QueryTYOLogisticsMsgDto.class);
        if (StringUtils.isBlank((String)dto.getMailNo())) {
            ytoLogisticsReturnVO.setSuccessAndReason(YTOErrorCodeReturnEnum.LOGISTICS_ERROR);
            return ytoLogisticsReturnVO;
        }
        ytoLogisticsReturnVO.setTxLogisticID(dto.getTxLogisticID());
        this.checkytoLogisticsMsgParam(ytoLogisticsReturnVO, newLogisticsInterface, dataDigest, clientId);
        if (!ytoLogisticsReturnVO.getSuccess().booleanValue()) {
            return ytoLogisticsReturnVO;
        }
        LogisticsOrderDto logisticsOrderDto = new LogisticsOrderDto();
        YTOLogisticsStatusEnum ytoLogisticsStatusEnum = YTOLogisticsStatusEnum.getByCode((String)dto.getInfoContent());
        if (StringUtils.isBlank((String)dto.getInfoContent()) || ytoLogisticsStatusEnum == null) {
            ytoLogisticsReturnVO.setSuccessAndReason(YTOErrorCodeReturnEnum.INFO_CONTENT_ERROR);
            return ytoLogisticsReturnVO;
        }
        logisticsOrderDto.setLogisticsStatus(ytoLogisticsStatusEnum.getDesc());
        logisticsOrderDto.setPostId(dto.getMailNo());
        logisticsOrderDto.setLogisticsCode(ExpressCompanyEnum.YTO.getCode());
        if (ytoLogisticsStatusEnum == YTOLogisticsStatusEnum.SENT_SCAN) {
            HashMap<String, String> deliveryMsg = new HashMap<String, String>();
            deliveryMsg.put(DELIVER_NAME, dto.getDeliveryName());
            deliveryMsg.put(CONTACT_INFO, dto.getContactInfo());
            logisticsOrderDto.setDeliveryMsg(deliveryMsg);
            logisticsOrderDto.setOrderStatus(LogisticsOrderStatusEnum.SENT_SCAN.getCode());
        } else if (ytoLogisticsStatusEnum == YTOLogisticsStatusEnum.SIGNED) {
            String[] refuseRemark;
            String lastProcessInfo = this.getLastProcessInfo(LogisticsNameEnum.YTO.getCode(), dto.getMailNo());
            if (StringUtils.indexOfAny((String)lastProcessInfo, (String[])(refuseRemark = new String[]{"\u7b7e\u6536\u4eba: \u9000\u4ef6", "\u7b7e\u6536\u4eba: \u9000\u56de"})) > 0) {
                logisticsOrderDto.setOrderStatus(LogisticsOrderStatusEnum.RETURN.getCode());
            } else {
                logisticsOrderDto.setOrderStatus(LogisticsOrderStatusEnum.SUCCESS.getCode());
            }
        } else if (ytoLogisticsStatusEnum == YTOLogisticsStatusEnum.FAILED) {
            logisticsOrderDto.setOrderStatus(LogisticsOrderStatusEnum.FAILED.getCode());
        } else if (ytoLogisticsStatusEnum == YTOLogisticsStatusEnum.ACCEPT) {
            logisticsOrderDto.setOrderStatus(LogisticsOrderStatusEnum.ACCEPT.getCode());
        } else if (ytoLogisticsStatusEnum == YTOLogisticsStatusEnum.GOT) {
            logisticsOrderDto.setOrderStatus(LogisticsOrderStatusEnum.UNDER_WAY.getCode());
        }
        DubboResult result = this.remoteLogisticsOrderService.updateLogisticsOrderStatus(logisticsOrderDto);
        if (!result.isSuccess() || result.getResult() == null || (Integer)result.getResult() <= 0) {
            ytoLogisticsReturnVO.setSuccessAndReason(YTOErrorCodeReturnEnum.TXLOGISTICID_NON_ERROR);
        }
        return ytoLogisticsReturnVO;
    }

    private String getLastProcessInfo(String logisticsCode, String postId) {
        try {
            DubboResult result = this.remoteLogisticsOrderService.queryWaybillTrace(logisticsCode, postId);
            if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getResult()))) {
                LogisticsProcessDto dto = (LogisticsProcessDto)((List)result.getResult()).get(0);
                return dto.getProcessInfo();
            }
            throw new QihoManagerException("\u6ca1\u6709\u67e5\u5230\u8d70\u4ef6\u4fe1\u606f\uff0cpostId=" + postId);
        }
        catch (Exception e) {
            LOG.warn("queryWaybillTrace\u63a5\u53e3\u67e5\u8be2\u8d85\u65f6\uff1alogisticsCode:{},postId:{}" + logisticsCode, (Object)postId);
            throw new QihoManagerException("\u6ca1\u6709\u67e5\u5230\u8d70\u4ef6\u4fe1\u606f\uff0cpostId=" + postId);
        }
    }

    public void checkytoLogisticsMsgParam(YTOLogisticsReturnVO ytoLogisticsReturnVO, String logisticsInterface, String dataDigest, String clientId) {
        if (!YTOInterfaceUtil.getClientId().equals(clientId)) {
            ytoLogisticsReturnVO.setSuccessAndReason(YTOErrorCodeReturnEnum.CLIENTID_ERROR);
            return;
        }
        String encryptionSign = MessageDigestUtils.toMD5Base64((String)(logisticsInterface + YTOInterfaceUtil.getPartnerId()));
        if (!StringUtils.equalsIgnoreCase((String)dataDigest, (String)encryptionSign)) {
            ytoLogisticsReturnVO.setSuccessAndReason(YTOErrorCodeReturnEnum.SIGN_ERROR);
            return;
        }
        ytoLogisticsReturnVO.setSuccessAndReason(YTOErrorCodeReturnEnum.SUCCESS);
    }

    @Override
    public List<LogisticsProcessDto> queryYTOLogisticsProcessByPostId(String postId, String logisticsCode) {
        DubboResult result = this.remoteLogisticsOrderService.queryWaybillTrace(logisticsCode, postId);
        return (List)result.getResult();
    }

    @Override
    public OrderDealWithVO batchSign(BatchAuditOrderParam param, String status) {
        return this.orderDealWithService.submitDealWithTask(param.getFileUrl(), status, LogisticsOrderSignHandler.class);
    }

    @Override
    public Boolean manualErpLogisticsSyncQueryTaskJob() {
        if (Environment.isPrepub() || Environment.isOnline()) {
            LOG.info("\u9884\u53d1\u73af\u5883\u548c\u7ebf\u4e0a\u73af\u5883\u4e0d\u6267\u884c\u624b\u52a8\u89e6\u53d1ERP\u7269\u6d41\u67e5\u8be2\u4efb\u52a1");
            return false;
        }
        DubboResult result = this.remoteLogisticsOrderService.manualErpLogisticsSyncQueryJob();
        return (Boolean)result.getResult();
    }

    @Override
    public void syncLogisticsStatus(String logisticsOrderStatus) {
        LOG.warn("\u5f00\u59cb\u540c\u6b65\u7269\u6d41\u72b6\u6001");
        this.remoteLogisticsOrderService.syncLogisticsStatus(logisticsOrderStatus);
    }

    @Override
    public Boolean updateLogisticsOrderRemark(LogisticsOrderDto param) {
        return this.remoteLogisticsOrderService.updateLogisticsOrderRemark(param);
    }

    @Override
    public Map<String, Object> submitExportDistributeOrder() {
        int count = this.remoteLogisticsOrderService.queryDistributeOverTimeNum();
        if (count <= 0) {
            throw new QihoManagerException("\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u8bb0\u5f55");
        }
        DistributeOrderExportRunnable runnable = (DistributeOrderExportRunnable)this.applicationContext.getBean(DistributeOrderExportRunnable.class);
        Map<String, Object> info = runnable.init();
        info.put("count", count);
        this.executorService.submit(runnable);
        return info;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public JSONObject queryExpressBlackExportStatus(String taskId) {
        CacheConstantseEnum constantseEnum = CacheConstantseEnum.EXPORT_DISTRIBUTE_LOGISTICS_ORDER;
        String cacheKey = constantseEnum.getCacheKey((Object)taskId);
        BoundHashOperations operations = this.redisTemplate.boundHashOps((Object)cacheKey);
        Map info = operations.entries();
        JSONObject json = new JSONObject();
        if (info.isEmpty()) {
            json.put("success", (Object)true);
        } else {
            json.putAll(info);
        }
        json.put("success", (Object)json.getBoolean("success"));
        return json;
    }

    @Override
    public Pagenation<LogisticsOrderVO> queryServiceList(QueryLogisticsOrderDto queryItem, Integer pageNum, Integer pageSize) {
        PagenationDto result = this.remoteLogisticsOrderService.queryServiceLogisticsOrder(queryItem, pageNum, pageSize);
        List logisticsOrderDtoList = result.getList();
        Pagenation<LogisticsOrderVO> page = new Pagenation<LogisticsOrderVO>();
        page.setTotal(result.getTotal());
        List<LogisticsOrderVO> logisticsOrderVOList = this.transformLogisticsOrderVO(logisticsOrderDtoList);
        page.setList(logisticsOrderVOList);
        return page;
    }
}

