/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.AfterSaleOrderDto;
import com.qiho.center.api.dto.AnticheateDto;
import com.qiho.center.api.dto.ChannelInfoDto;
import com.qiho.center.api.dto.ErpOrderDto;
import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SkinDto;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.dto.order.BatchOrderDto;
import com.qiho.center.api.dto.order.BatchOrderExtDto;
import com.qiho.center.api.dto.order.BatchOrderProcessDto;
import com.qiho.center.api.dto.page.BaiqiPageDto;
import com.qiho.center.api.enums.AfterSaleOrderReasonEnum;
import com.qiho.center.api.enums.AfterSaleOrderStatusEnum;
import com.qiho.center.api.enums.AfterSaleOrderTypeEnum;
import com.qiho.center.api.enums.DeliveryEnum;
import com.qiho.center.api.enums.ErpStatusEnum;
import com.qiho.center.api.enums.ErpTypeEnum;
import com.qiho.center.api.enums.FundBizTypeEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.params.OrderConsumerParam;
import com.qiho.center.api.params.OrderItemParam;
import com.qiho.center.api.params.OrderPageParams;
import com.qiho.center.api.remoteservice.RemoteConfigService;
import com.qiho.center.api.remoteservice.RemoteLogisticsOrderService;
import com.qiho.center.api.remoteservice.RemoteSkinService;
import com.qiho.center.api.remoteservice.order.RemoteAfterSaleOrderService;
import com.qiho.center.api.remoteservice.order.RemoteAnticheateService;
import com.qiho.center.api.remoteservice.order.RemoteChannelInfoService;
import com.qiho.center.api.remoteservice.order.RemoteErpOrderService;
import com.qiho.center.api.remoteservice.order.RemoteFundOrderService;
import com.qiho.center.api.remoteservice.order.RemoteOrderService;
import com.qiho.center.api.remoteservice.page.RemotePageBackendService;
import com.qiho.manager.biz.params.BatchAuditOrderParam;
import com.qiho.manager.biz.runnable.OrdersExportRunnable;
import com.qiho.manager.biz.service.OrderDealWithService;
import com.qiho.manager.biz.service.OrderService;
import com.qiho.manager.biz.vo.AfterSaleVO;
import com.qiho.manager.biz.vo.ChannelInfoVO;
import com.qiho.manager.biz.vo.ErpOrderVO;
import com.qiho.manager.biz.vo.FundVO;
import com.qiho.manager.biz.vo.LogisticsVO;
import com.qiho.manager.biz.vo.OrderDealWithVO;
import com.qiho.manager.biz.vo.OrderDetailExtVo;
import com.qiho.manager.biz.vo.OrderDetailVO;
import com.qiho.manager.biz.vo.OrderItemVO;
import com.qiho.manager.biz.vo.OrderSkinVO;
import com.qiho.manager.biz.vo.OrderSnapshotVO;
import com.qiho.manager.biz.vo.OrderVO;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.coupon.CouponOrderVO;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.util.Environment;
import com.qiho.manager.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
implements OrderService,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Autowired
    private RemoteOrderService remoteOrderService;
    @Autowired
    private RemoteFundOrderService remoteFundOrderService;
    @Autowired
    private RemoteErpOrderService remoteErpOrderService;
    @Autowired
    private RemoteLogisticsOrderService remoteLogisticsOrderService;
    @Autowired
    private RemoteChannelInfoService remoteChannelInfoService;
    @Autowired
    private RemoteAnticheateService remoteAnticheateService;
    @Autowired
    private RemoteAfterSaleOrderService remoteAfterSaleOrderService;
    @Autowired
    private ApplicationContext applicationContext;
    @Resource
    private ExecutorService executorService;
    @Autowired
    private OrderDealWithService orderDealWithService;
    @Autowired
    private RemoteSkinService remoteSkinService;
    @Resource
    private RemotePageBackendService remotePageBackendService;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;
    @Autowired
    private RemoteConfigService remoteConfigService;

    @Override
    public OrderDetailVO findByOrderId(String orderId) {
        OrderDetailVO orderDetail = new OrderDetailVO();
        OrderDto orderDto = (OrderDto)this.remoteOrderService.findByOrderId(orderId).getResult();
        OrderVO order = this.getOrderVO(orderDto);
        orderDetail.setOrder(order);
        OrderItemVO orderItemVO = (OrderItemVO)BeanUtils.copy((Object)orderDto.getOrderItem(), OrderItemVO.class);
        orderDetail.setOrderItem(orderItemVO);
        List<FundVO> fundList = this.getFundList(orderId);
        orderDetail.setFundList(fundList);
        List<ErpOrderVO> erpOrderList = this.getErpOrderList(orderId);
        orderDetail.setErpOrderList(erpOrderList);
        List<LogisticsVO> logisticsList = this.getLogisticsList(orderId);
        orderDetail.setLogisticsList(logisticsList);
        ChannelInfoVO channelInfo = this.getChannelInfoVO(orderId);
        orderDetail.setChannelInfo(channelInfo);
        List<String> anticheateList = this.getAnticheateList(orderId);
        orderDetail.setAnticheateList(anticheateList);
        OrderSkinVO skinItem = this.getSkinVO(channelInfo.getUrl(), channelInfo.getSkinId());
        orderDetail.setSkinItem(skinItem);
        List<AfterSaleVO> afterSaleList = this.getAfterSaleList(orderId);
        orderDetail.setAfterSaleList(afterSaleList);
        orderDetail.setCouponList(new ArrayList<CouponOrderVO>());
        this.setOrderExt(orderId, orderDetail, orderDto);
        return orderDetail;
    }

    private List<AfterSaleVO> getAfterSaleList(String orderId) {
        List dtoList = this.remoteAfterSaleOrderService.findAll(orderId);
        ArrayList afterSaleList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)dtoList)) {
            return afterSaleList;
        }
        for (AfterSaleOrderDto dto : dtoList) {
            AfterSaleVO afterSale = (AfterSaleVO)BeanUtils.copy((Object)dto, AfterSaleVO.class);
            afterSale.setAfterSaleType(AfterSaleOrderTypeEnum.getByCode((String)dto.getAfterSaleType()).getDesc());
            afterSale.setAfterSaleReason(AfterSaleOrderReasonEnum.getByCode((String)dto.getAfterSaleReason()).getMsg());
            afterSale.setAfterSaleStatus(AfterSaleOrderStatusEnum.getByCode((String)dto.getAfterSaleStatus()).getMsg());
            afterSale.setGmtCreate(DateUtils.getSecondStr((Date)dto.getGmtCreate()));
            afterSale.setGmtModified(DateUtils.getSecondStr((Date)dto.getGmtModified()));
            afterSale.setFreightAmt(dto.getRefreightAmt());
            afterSale.setAfterSaleId(dto.getAfterSaleId());
            afterSaleList.add(afterSale);
        }
        return afterSaleList;
    }

    private OrderSkinVO getSkinVO(String url, Long skinId) {
        OrderSkinVO skinItem = new OrderSkinVO();
        skinItem.setSkinId(skinId);
        if (url.contains("detail2")) {
            BaiqiPageDto pageDto = this.remotePageBackendService.findById(skinId);
            if (pageDto != null) {
                skinItem.setSkinName(pageDto.getPageName());
            }
        } else {
            try {
                DubboResult result = this.remoteSkinService.querySkinById(skinId);
                if (result.isSuccess() && result.getResult() != null) {
                    skinItem.setSkinName(((SkinDto)result.getResult()).getSkinName());
                }
            }
            catch (QihoManagerException e) {
                logger.error("order detail get skin info error, skinId:{} ", (Object)skinId);
            }
        }
        return skinItem;
    }

    @Override
    public Map<String, Object> submitOrdersExport(OrderPageParams params) {
        OrdersExportRunnable runnable = (OrdersExportRunnable)this.applicationContext.getBean(OrdersExportRunnable.class);
        runnable.setParams(params);
        Map<String, Object> info = runnable.init();
        this.executorService.submit(runnable);
        return info;
    }

    private List<String> getAnticheateList(String orderId) {
        AnticheateDto anticheateDto = (AnticheateDto)this.remoteAnticheateService.findByOrderId(orderId).getResult();
        return anticheateDto.getRules();
    }

    private ChannelInfoVO getChannelInfoVO(String orderId) {
        ChannelInfoDto channelInfo = (ChannelInfoDto)this.remoteChannelInfoService.findByOrderId(orderId).getResult();
        ChannelInfoVO channelInfoVO = (ChannelInfoVO)BeanUtils.copy((Object)channelInfo, ChannelInfoVO.class);
        channelInfoVO.setTongdunId(channelInfo.getTongdunId());
        channelInfoVO.setMaxentId(channelInfo.getMaxentId());
        return channelInfoVO;
    }

    private List<LogisticsVO> getLogisticsList(String orderId) {
        List list = (List)this.remoteLogisticsOrderService.findByOrderId(orderId).getResult();
        ArrayList logisticsList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return logisticsList;
        }
        for (LogisticsOrderDto logisticsOrder : list) {
            LogisticsVO logisticsVO = (LogisticsVO)BeanUtils.copy((Object)logisticsOrder, LogisticsVO.class);
            logisticsVO.setGmtCreate(DateUtils.getSecondStr((Date)logisticsOrder.getGmtCreate()));
            logisticsVO.setGmtModified(DateUtils.getSecondStr((Date)logisticsOrder.getGmtModified()));
            LogisticsOrderStatusEnum orderStatus = LogisticsOrderStatusEnum.getByCode((String)logisticsOrder.getOrderStatus());
            if (orderStatus != null) {
                logisticsVO.setOrderStatus(orderStatus.getDesc());
            }
            logisticsVO.setOrderStatusModified(DateUtils.getSecondStr((Date)logisticsOrder.getOrderStatusModified()));
            logisticsList.add(logisticsVO);
        }
        return logisticsList;
    }

    private List<ErpOrderVO> getErpOrderList(String orderId) {
        List list = (List)this.remoteErpOrderService.findByOrderId(orderId).getResult();
        ArrayList erpOrderList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return erpOrderList;
        }
        for (ErpOrderDto erpOrder : list) {
            ErpOrderVO erpOrderVO = (ErpOrderVO)BeanUtils.copy((Object)erpOrder, ErpOrderVO.class);
            erpOrderVO.setErpStatus(ErpStatusEnum.getByCode((String)erpOrder.getErpStatus()).getDesc());
            erpOrderVO.setErpType(ErpTypeEnum.getByCode((String)erpOrder.getErpType()).getDesc());
            erpOrderVO.setGmtCreate(DateUtils.getSecondStr((Date)erpOrder.getGmtCreate()));
            erpOrderVO.setGmtModified(DateUtils.getSecondStr((Date)erpOrder.getGmtModified()));
            erpOrderList.add(erpOrderVO);
        }
        return erpOrderList;
    }

    private List<FundVO> getFundList(String orderId) {
        List list = (List)this.remoteFundOrderService.findByOrderId(orderId).getResult();
        ArrayList fundList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return fundList;
        }
        for (FundOrderDto fundOrder : list) {
            FundVO fundVO = (FundVO)BeanUtils.copy((Object)fundOrder, FundVO.class);
            fundVO.setFundStatus(FundStatusEnum.getEnumByCode((String)fundOrder.getFundStatus()).getDesc());
            fundVO.setPayType(PayTypeEnum.getEnumByCode((String)fundOrder.getPayType()).getDesc());
            fundVO.setGmtCreate(DateUtils.getSecondStr((Date)fundOrder.getGmtCreate()));
            fundVO.setGmtModified(DateUtils.getSecondStr((Date)fundOrder.getGmtModified()));
            fundVO.setBizType(FundBizTypeEnum.getByCode((String)fundOrder.getBizType()).getDesc());
            fundVO.setAfterSaleId(fundOrder.getAftersaleId());
            fundList.add(fundVO);
        }
        return fundList;
    }

    private OrderVO getOrderVO(OrderDto orderDto) {
        OrderVO order = (OrderVO)BeanUtils.copy((Object)orderDto, OrderVO.class);
        if (!this.orderPrimitiveAuth()) {
            order.setConsumerName(StringUtil.hideConsumerInfo((String)orderDto.getConsumerName()));
            order.setMobile(StringUtil.hideMobileInfo((String)orderDto.getMobile()));
            order.setIdCard(this.hideIdCard(orderDto.getIdCard()));
        }
        order.setGmtCreate(DateUtils.getSecondStr((Date)orderDto.getGmtCreate()));
        order.setGmtModified(DateUtils.getSecondStr((Date)orderDto.getGmtModified()));
        order.setDelivery(DeliveryEnum.getByCode((String)orderDto.getOrderItem().getDelivery()).getDesc());
        order.setOrderStatus(OrderStatusEnum.getByCode((String)orderDto.getOrderStatus()).getDesc());
        order.setSponsorAftersale(this.remoteAfterSaleOrderService.sponsorAfterSale(orderDto.getOrderId()));
        return order;
    }

    private void setOrderExt(String orderId, OrderDetailVO orderDetail, OrderDto orderDto) {
        String jsonExt = orderDto.getExtJson();
        if (StringUtils.isNotBlank((CharSequence)jsonExt)) {
            try {
                orderDetail.getOrder().setExt((OrderDetailExtVo)JSONObject.parseObject((String)jsonExt, OrderDetailExtVo.class));
            }
            catch (Exception e) {
                logger.info("\u89e3\u6790\u8ba2\u5355\u6269\u5c55\u6570\u636e\u9519\u8bef {}", (Object)orderId, (Object)e);
            }
        }
    }

    private String hideIdCard(String idCard) {
        if (StringUtils.isBlank((CharSequence)idCard)) {
            return idCard;
        }
        if (idCard.length() > 3 && idCard.length() < 7) {
            return idCard.substring(0, 3) + "****";
        }
        if (idCard.length() >= 7) {
            return idCard.substring(0, 3) + "****" + idCard.substring(idCard.length() - 4, idCard.length());
        }
        return "****";
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void updateOrderItem(OrderItemParam orderItemParam) {
        DubboResult result = this.remoteOrderService.updateOrderItem(orderItemParam);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
    }

    @Override
    public void updateOrderConsumer(OrderConsumerParam orderConsumerParam) {
        DubboResult result = this.remoteOrderService.updateOrderConsumer(orderConsumerParam);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
    }

    @Override
    public OrderDealWithVO batchAuditOrder(BatchAuditOrderParam param) {
        logger.info("BatchAuditOrder param:{},adminId:{}", (Object)JSON.toJSONString((Object)param), (Object)RequestTool.getAdminId());
        BatchOrderDto batchOrderDto = new BatchOrderDto();
        batchOrderDto.setFileUrl(param.getFileUrl());
        batchOrderDto.setMerchantId(Long.valueOf(-1L));
        String taskId = this.orderDealWithService.createTaskId();
        batchOrderDto.setTaskId(taskId);
        DubboResult integerDubboResult = this.remoteOrderService.batchAuditOrder(batchOrderDto);
        OrderDealWithVO orderDealWithVO = new OrderDealWithVO();
        orderDealWithVO.setCount((Integer)integerDubboResult.getResult());
        orderDealWithVO.setTaskId(taskId);
        return orderDealWithVO;
    }

    @Override
    public Pagenation<OrderSnapshotVO> findApproveOrder(OrderPageParams params) {
        PagenationDto pagenationDto = (PagenationDto)this.remoteOrderService.findAllPage(params).getResult();
        List dtoList = pagenationDto.getList();
        if (CollectionUtils.isEmpty((Collection)dtoList)) {
            return new Pagenation<OrderSnapshotVO>();
        }
        ArrayList orderIddList = Lists.newArrayList();
        for (OrderSnapshotDto dto2 : dtoList) {
            orderIddList.add(dto2.getOrderId());
        }
        List anticheateDtoList = (List)this.remoteAnticheateService.findByOrderIds((List)orderIddList).getResult();
        for (int i = 0; i < dtoList.size(); ++i) {
            ((OrderSnapshotDto)dtoList.get(i)).setAnticheatRules(((AnticheateDto)anticheateDtoList.get(i)).getRules().toString());
        }
        List orderSnapshotVOList = Lists.transform((List)dtoList, dto -> {
            OrderSnapshotVO vo = (OrderSnapshotVO)BeanUtils.copy((Object)dto, OrderSnapshotVO.class);
            vo.setGmtCreate(DateUtils.getSecondStr((Date)dto.getGmtCreate()));
            vo.setOrderStatus(dto.getOrderStatusEnum().getDesc());
            vo.setFundStatus(dto.getFundStatusEnum() == null ? "" : dto.getFundStatusEnum().getDesc());
            vo.setAmt(dto.getOrderAmt());
            return vo;
        });
        Pagenation<OrderSnapshotVO> pageList = new Pagenation<OrderSnapshotVO>();
        pageList.setList(orderSnapshotVOList);
        pageList.setTotal(pagenationDto.getTotal());
        return pageList;
    }

    @Override
    public String overTask(String taskId) {
        String redisKey = CacheConstantseEnum.EXPORT_ORDER_CACEL + ":" + taskId;
        this.advancedCacheClient.set(redisKey, (Object)taskId, CacheConstantseEnum.EXPORT_ORDER_CACEL.getTime().intValue(), CacheConstantseEnum.EXPORT_ORDER_CACEL.getTimeUnit());
        return "\u4efb\u52a1\u7ed3\u675f\u6210\u529f\uff1a" + taskId;
    }

    @Override
    public boolean orderPrimitiveAuth() {
        try {
            List authValue = (List)this.advancedCacheClient.get(CacheConstantseEnum.ORDER_PRIMITIVE_AUTH_EMAIL.toString());
            if (authValue == null) {
                String configValue = this.remoteConfigService.fetchConfigByName("ORDER_PRIMITIVE_AUTH_EMAIL").getConfigValue();
                Splitter splitter = Splitter.on((String)",");
                authValue = splitter.splitToList((CharSequence)configValue);
                if (Environment.isDaily()) {
                    this.advancedCacheClient.set(CacheConstantseEnum.ORDER_PRIMITIVE_AUTH_EMAIL.toString(), (Object)authValue, 5, TimeUnit.MINUTES);
                } else {
                    this.advancedCacheClient.set(CacheConstantseEnum.ORDER_PRIMITIVE_AUTH_EMAIL.toString(), (Object)authValue, CacheConstantseEnum.ORDER_PRIMITIVE_AUTH_EMAIL.getTime().intValue(), CacheConstantseEnum.ORDER_PRIMITIVE_AUTH_EMAIL.getTimeUnit());
                }
            }
            String user = RequestTool.getAdmin().getEmail();
            return authValue.contains(user);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8ba2\u5355\u539f\u59cb\u4fe1\u606f\u6743\u9650\u9519\u8bef, user={}", (Object)RequestTool.getAdmin().getName(), (Object)e);
            return false;
        }
    }

    @Override
    public void batchProcessOrder(Integer type, String fileUrl, String fileName) {
        BatchOrderProcessDto batchOrderProcessDto = new BatchOrderProcessDto();
        batchOrderProcessDto.setType(type.intValue());
        batchOrderProcessDto.setFileUrl(fileUrl);
        batchOrderProcessDto.setMerchantId(Long.valueOf(-1L));
        batchOrderProcessDto.setFileName(fileName);
        this.remoteOrderService.batchProcessOrder(batchOrderProcessDto);
    }

    @Override
    public Map<String, Integer> getOrderExportStatusMap(List<String> extList) {
        if (CollectionUtils.isEmpty(extList)) {
            return Maps.newHashMap();
        }
        ArrayList orderExtDtos = Lists.newArrayList();
        extList.forEach(orderId -> {
            BatchOrderExtDto dto = new BatchOrderExtDto();
            dto.setOrderId(orderId);
            orderExtDtos.add(dto);
        });
        List dtos = this.remoteOrderService.getOrderExt((List)orderExtDtos);
        if (CollectionUtils.isEmpty((Collection)dtos)) {
            return Maps.newHashMap();
        }
        return dtos.stream().collect(Collectors.toMap(BatchOrderExtDto::getOrderId, BatchOrderExtDto::getOrderExportStatus, (a, b) -> a));
    }
}

