/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SkinDto;
import com.qiho.center.api.params.QuerySkinParams;
import com.qiho.center.api.remoteservice.RemoteSkinService;
import com.qiho.manager.biz.service.SkinService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.SkinVO;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.util.ReadResourceUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SkinServiceImpl
implements SkinService {
    @Autowired
    private RemoteSkinService remoteSkinService;
    @Autowired
    private RemoteAdminService remoteAdminService;
    private static final Logger logger = LoggerFactory.getLogger(SkinServiceImpl.class);

    @Override
    public Long createSkin(SkinDto skinDto) {
        DubboResult result = this.remoteSkinService.createSkin(skinDto);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        return (Long)result.getResult();
    }

    @Override
    public Boolean updateSkin(SkinDto skinDto) {
        DubboResult result = this.remoteSkinService.updateSkin(skinDto);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        return (Boolean)result.getResult();
    }

    @Override
    public Boolean deleteSkin(Long id, Long gmtModifier) {
        DubboResult result = this.remoteSkinService.deleteSkin(id, gmtModifier);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        return (Boolean)result.getResult();
    }

    @Override
    public SkinVO querySkinById(Long id) {
        DubboResult result = this.remoteSkinService.querySkinById(id);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        SkinVO skinVO = this.convertVOSimple((SkinDto)result.getResult());
        if (skinVO != null) {
            AdminDto adminDto = null;
            try {
                adminDto = this.remoteAdminService.findOneAdmin(((SkinDto)result.getResult()).getGmtModifier());
                skinVO.setGmtModifier(adminDto.getName());
                skinVO.setEmail(adminDto.getEmail());
            }
            catch (Exception e) {
                logger.warn("\u83b7\u53d6admin\u5f02\u5e38\uff0cdata = {}\uff0c", (Object)((SkinDto)result.getResult()).getGmtModifier(), (Object)e);
                skinVO.setGmtModifier("");
                skinVO.setEmail("");
            }
        }
        return skinVO;
    }

    @Override
    public Pagenation<SkinVO> queryAllSkin(QuerySkinParams params) {
        DubboResult result = this.remoteSkinService.queryAllSkin(params);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        PagenationDto pagenationDto = (PagenationDto)result.getResult();
        List skinVOList = Lists.transform((List)pagenationDto.getList(), this::convertVO);
        Pagenation<SkinVO> pagenation = new Pagenation<SkinVO>();
        pagenation.setList(skinVOList);
        pagenation.setTotal(pagenationDto.getTotal());
        return pagenation;
    }

    @Override
    public Pagenation<SkinVO> queryBySkinId(Long id) {
        DubboResult result = this.remoteSkinService.querySkinById(id);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        if (null == result.getResult()) {
            return null;
        }
        ArrayList<SkinVO> skinVOList = new ArrayList<SkinVO>();
        skinVOList.add(this.convertVO((SkinDto)result.getResult()));
        Pagenation<SkinVO> pagenation = new Pagenation<SkinVO>();
        pagenation.setList(skinVOList);
        pagenation.setTotal(1);
        return pagenation;
    }

    private SkinVO convertVOSimple(SkinDto dto) {
        if (dto == null) {
            return null;
        }
        SkinVO vo = new SkinVO();
        BeanUtils.copyProperties((Object)dto, (Object)vo);
        vo.setSkinId(dto.getId());
        vo.setGmtModified(DateUtils.getSecondStr((long)dto.getGmtModified()));
        vo.setCssStr(ReadResourceUtil.readResource((String)dto.getCssUrl()));
        vo.setHtmlStr(ReadResourceUtil.readResource((String)dto.getHtmlUrl()));
        vo.setJavascriptStr(ReadResourceUtil.readResource((String)dto.getJavascriptUrl()));
        return vo;
    }

    private SkinVO convertVO(SkinDto dto) {
        if (dto == null) {
            return null;
        }
        SkinVO vo = new SkinVO();
        BeanUtils.copyProperties((Object)dto, (Object)vo);
        vo.setSkinId(dto.getId());
        vo.setGmtModified(DateUtils.getSecondStr((long)dto.getGmtModified()));
        return vo;
    }
}

