/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.warning.StockWarningDto;
import com.qiho.center.api.params.warning.StockWarningParams;
import com.qiho.center.api.remoteservice.warning.RemoteStockWarningService;
import com.qiho.manager.biz.service.warning.StockWarningService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.warning.WarningVo;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class StockWarningServiceImpl
implements StockWarningService {
    @Resource
    RemoteStockWarningService remoteStockWarningService;

    @Override
    public Pagenation<WarningVo> queryListByParam(StockWarningParams params) {
        PagenationDto pg = this.remoteStockWarningService.queryByParam(params);
        Pagenation<WarningVo> pagenationDto = new Pagenation<WarningVo>();
        pagenationDto.setTotal(pg.getTotal());
        ArrayList list = Lists.newArrayList();
        for (StockWarningDto stockWarningDto : pg.getList()) {
            WarningVo vo = (WarningVo)BeanUtils.copy((Object)stockWarningDto, WarningVo.class);
            if (stockWarningDto.getWarnStatus() == 0) {
                vo.setWarnStatus("\u9884\u8b66");
            } else {
                vo.setWarnStatus("\u7f3a\u8d27");
            }
            vo.setSuggestStock((long)stockWarningDto.getSuggestNum());
            vo.setStock((long)stockWarningDto.getStockNum());
            vo.setGmtCreate(DateUtils.getSecondStr((Date)stockWarningDto.getGmtCreate()));
            list.add(vo);
        }
        pagenationDto.setList(list);
        return pagenationDto;
    }
}

