/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.TabDto;
import com.qiho.center.api.remoteservice.RemoteTabService;
import com.qiho.center.api.util.JSONUtil;
import com.qiho.manager.biz.service.TabService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.TabVO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class TabServiceImpl
implements TabService {
    private static final String DEFAULT_TAB_STYLE_CONFIG = "{\"tabStyleId\":1}";
    @Resource
    RemoteTabService remoteTabService;

    @Override
    public DubboResult<Integer> add(TabDto tabDto) {
        return this.remoteTabService.add(tabDto);
    }

    @Override
    public DubboResult<Integer> deleteList(List<Long> ids) {
        return this.remoteTabService.deleteList(ids);
    }

    @Override
    public DubboResult<Integer> update(TabDto tabDto) {
        return this.remoteTabService.update(tabDto);
    }

    @Override
    public TabVO queryDetail(Long id) {
        DubboResult tabDto = this.remoteTabService.queryDetail(id);
        TabVO tabVO = (TabVO)BeanUtils.copy((Object)tabDto.getResult(), TabVO.class);
        if (tabDto.getResult() != null) {
            if (((TabDto)tabDto.getResult()).getStatus().equals("0")) {
                tabVO.setStatus(true);
            } else {
                tabVO.setStatus(false);
            }
        }
        return tabVO;
    }

    @Override
    public Pagenation<TabVO> queryList() {
        DubboResult dubboResult = this.remoteTabService.queryList();
        ArrayList vos = Lists.newArrayList();
        List dtos = ((PagenationDto)dubboResult.getResult()).getList();
        if (dtos != null) {
            for (TabDto dto : dtos) {
                TabVO tabVO = (TabVO)BeanUtils.copy((Object)dto, TabVO.class);
                if (dto != null) {
                    if (dto.getStatus().equals("0")) {
                        tabVO.setStatus(true);
                    } else {
                        tabVO.setStatus(false);
                    }
                    String tabStyleConfig = dto.getTabStyleConfig();
                    tabVO.setTabStyleConfig(JSONUtil.strToJSON((String)(StringUtils.isNotEmpty((String)tabStyleConfig) ? tabStyleConfig : DEFAULT_TAB_STYLE_CONFIG)));
                }
                vos.add(tabVO);
            }
        }
        Pagenation<TabVO> pagenation = new Pagenation<TabVO>();
        pagenation.setList(vos);
        return pagenation;
    }

    @Override
    public DubboResult<Boolean> sortByPayLoad(Long sortId, Integer startPayload, Integer endPayload) {
        return this.remoteTabService.sortByPayLoad(sortId, startPayload, endPayload);
    }
}

