/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ItemDetailDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.abtest.TestMetadataDto;
import com.qiho.center.api.dto.abtest.TestPlanDto;
import com.qiho.center.api.enums.MetadataTypeEnum;
import com.qiho.center.api.enums.PlanStatusEnum;
import com.qiho.center.api.params.TestPlanQueryParam;
import com.qiho.center.api.remoteservice.RemoteItemService;
import com.qiho.center.api.remoteservice.abtest.RemoteTestMetadataService;
import com.qiho.center.api.remoteservice.abtest.RemoteTestPlanService;
import com.qiho.manager.biz.service.TestPlanService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.abtest.ItemTestMetadataVO;
import com.qiho.manager.biz.vo.abtest.TestMetadataVO;
import com.qiho.manager.biz.vo.abtest.TestPlanDetailVO;
import com.qiho.manager.biz.vo.abtest.TestPlanVO;
import com.qiho.manager.common.exception.QihoManagerException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TestPlanServiceImpl
implements TestPlanService {
    private Logger logger = LoggerFactory.getLogger(TestPlanServiceImpl.class);
    @Resource
    RemoteTestPlanService remoteTestPlanService;
    @Resource
    RemoteItemService remoteItemService;
    @Resource
    RemoteTestMetadataService remoteTestMetadataService;

    @Override
    public Pagenation<TestPlanVO> queryPageList(TestPlanQueryParam param) {
        Pagenation<TestPlanVO> page = new Pagenation<TestPlanVO>();
        PagenationDto result = this.remoteTestPlanService.queryTestPlanListByPage(param);
        page.setTotal(result.getTotal());
        ArrayList list = Lists.newArrayList();
        result.getList().stream().forEach(dto -> {
            TestPlanVO testPlanVO = new TestPlanVO();
            testPlanVO.setId(dto.getId());
            testPlanVO.setItemId(dto.getItemId());
            testPlanVO.setPlanName(dto.getPlanName());
            testPlanVO.setPlanDesc(dto.getPlanDesc());
            testPlanVO.setStartTime(DateUtils.getSecondStr((Date)dto.getStartTime()));
            testPlanVO.setEndTime(DateUtils.getSecondStr((Date)dto.getEndTime()));
            testPlanVO.setItemName(dto.getItemName());
            testPlanVO.setCreator(dto.getCreator());
            testPlanVO.setUpdator(dto.getUpdator());
            testPlanVO.setGmtCreate(DateUtils.getSecondStr((Date)dto.getGmtCreate()));
            testPlanVO.setGmtModified(DateUtils.getSecondStr((Date)dto.getGmtModified()));
            testPlanVO.setPlanType(MetadataTypeEnum.getByCode((String)dto.getPlanType()).getDesc());
            if (StringUtils.equals((CharSequence)PlanStatusEnum.TO_PUBLISH.getCode(), (CharSequence)dto.getPlanStatus())) {
                testPlanVO.setPlanStatus("\u672a\u53d1\u5e03");
            } else if (StringUtils.equals((CharSequence)PlanStatusEnum.PAUSE.getCode(), (CharSequence)dto.getPlanStatus())) {
                testPlanVO.setPlanStatus("\u6682\u505c\u4e2d");
            } else if (dto.getStartTime().after(new Date())) {
                testPlanVO.setPlanStatus("\u672a\u5f00\u59cb");
            } else if (dto.getEndTime().before(new Date())) {
                testPlanVO.setPlanStatus("\u5df2\u7ed3\u675f");
            } else {
                testPlanVO.setPlanStatus("\u8fdb\u884c\u4e2d");
            }
            list.add(testPlanVO);
        });
        page.setList(list);
        return page;
    }

    @Override
    public ItemTestMetadataVO queryTestMetadataByItemId(Long itemId) {
        ItemTestMetadataVO vo = new ItemTestMetadataVO();
        DubboResult dubboResult = this.remoteItemService.queryItemDetail(itemId);
        if (null == dubboResult.getResult()) {
            throw new QihoManagerException("\u8be5\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (dubboResult.isSuccess()) {
            vo.setItemId(itemId);
            vo.setItemName(((ItemDetailDto)dubboResult.getResult()).getItemName());
            vo.setPicUrl(((ItemDetailDto)dubboResult.getResult()).getExtParamValue("image"));
        }
        vo.setPriceList(this.transformData(this.remoteTestMetadataService.selectListByItemIdAndType(itemId, MetadataTypeEnum.PRICE.getCode())));
        vo.setDetailList(this.transformData(this.remoteTestMetadataService.selectListByItemIdAndType(itemId, MetadataTypeEnum.DETAIL.getCode())));
        List allSkinList = this.remoteTestMetadataService.selectListByItemIdAndType(itemId, MetadataTypeEnum.SKIN.getCode());
        ArrayList skinList = Lists.newArrayList();
        ArrayList pageList = Lists.newArrayList();
        allSkinList.stream().forEach(skin -> {
            if (skin.getSkinType() == 0) {
                skinList.add(skin);
            } else {
                pageList.add(skin);
            }
        });
        vo.setSkinList(this.transformData(skinList));
        vo.setPageList(this.transformData(pageList));
        return vo;
    }

    private List<TestMetadataVO> transformData(List<TestMetadataDto> priceList) {
        ArrayList resultlist = Lists.newArrayList();
        if (CollectionUtils.isEmpty(priceList)) {
            return resultlist;
        }
        priceList.stream().forEach(dto -> {
            TestMetadataVO vo = new TestMetadataVO();
            vo.setId(dto.getId());
            vo.setItemId(dto.getItemId());
            vo.setMetadataName(dto.getDataName());
            vo.setMetadataDesc(dto.getDataDesc());
            vo.setKeyType(dto.getMetadataKey());
            vo.setSelected(false);
            resultlist.add(vo);
        });
        return resultlist;
    }

    @Override
    public boolean deleteTestPlan(Long planId, String updator) {
        return this.remoteTestPlanService.deleteTestPlan(planId, updator);
    }

    @Override
    public boolean updateTestPlanStatus(Long planId, String planStatus, String updator) {
        try {
            return this.remoteTestPlanService.updatePlanStatus(planId, planStatus, updator);
        }
        catch (BizException exception) {
            throw new QihoManagerException(exception.getMessage());
        }
    }

    @Override
    public void saveTestPlan(TestPlanDto testPlanDto) {
        try {
            this.remoteTestPlanService.saveTestPlan(testPlanDto);
        }
        catch (BizException e) {
            throw new QihoManagerException(e.getMessage());
        }
    }

    @Override
    public TestPlanVO queryTestEditInfo(Long planId) {
        TestPlanDto testPlanDto = this.remoteTestPlanService.queryTestPlanById(planId);
        if (null == testPlanDto) {
            return null;
        }
        TestPlanVO testPlanVO = (TestPlanVO)BeanUtils.copy((Object)testPlanDto, TestPlanVO.class);
        testPlanVO.setStartTime(DateUtils.getSecondStr((Date)testPlanDto.getStartTime()));
        testPlanVO.setEndTime(DateUtils.getSecondStr((Date)testPlanDto.getEndTime()));
        if (StringUtils.equals((CharSequence)testPlanDto.getPlanStatus(), (CharSequence)PlanStatusEnum.NORMAL.getCode()) && testPlanDto.getEndTime().before(new Date())) {
            testPlanVO.setEdit(false);
        } else {
            testPlanVO.setEdit(true);
        }
        ArrayList list = Lists.newArrayList();
        testPlanDto.getDetailDtoList().stream().forEach(detailDto -> {
            TestPlanDetailVO detailVO = new TestPlanDetailVO();
            detailVO.setFlowPercent(detailDto.getFlowPercent());
            detailVO.setMetadataPriceId((Long)detailDto.getParam().get(MetadataTypeEnum.PRICE.getCode()));
            detailVO.setMetadataSkinId((Long)detailDto.getParam().get(MetadataTypeEnum.SKIN.getCode()));
            detailVO.setMetatataDetailId((Long)detailDto.getParam().get(MetadataTypeEnum.DETAIL.getCode()));
            list.add(detailVO);
        });
        testPlanVO.setDetailVOList(list);
        return testPlanVO;
    }

    @Override
    public void publisTestPlan(Long planId) {
        try {
            this.remoteTestPlanService.publishTestPlan(planId);
        }
        catch (BizException e) {
            this.logger.error("TestPlanServiceImpl call publisTestPlan error,planId = {}", (Object)planId, (Object)e);
            throw new QihoManagerException(e.getMessage());
        }
    }
}

