/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl.component;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.component.ComponentDto;
import com.qiho.center.api.dto.page.BaiqiPageDto;
import com.qiho.center.api.dto.page.PageComponentDetailDto;
import com.qiho.center.api.dto.page.PageComponentDto;
import com.qiho.center.api.enums.page.JSPlatformEnum;
import com.qiho.center.api.enums.page.PageStatusEnum;
import com.qiho.center.api.enums.page.PageTypeEnum;
import com.qiho.center.api.remoteservice.component.RemoteComponentService;
import com.qiho.center.api.remoteservice.page.RemotePageComponentService;
import com.qiho.manager.biz.params.component.ComponentPageCopyParam;
import com.qiho.manager.biz.params.component.ComponentPagePreParam;
import com.qiho.manager.biz.params.component.ComponentPageSaveParam;
import com.qiho.manager.biz.params.component.ComponentSimpleParam;
import com.qiho.manager.biz.process.component.ComponentPageDecider;
import com.qiho.manager.biz.process.component.ComponentPageProcessor;
import com.qiho.manager.biz.service.component.ComponentPageService;
import com.qiho.manager.biz.service.page.impl.PageServiceImpl;
import com.qiho.manager.biz.vo.component.ComponentPagePreviewVO;
import com.qiho.manager.biz.vo.component.ComponentSimpleVO;
import com.qiho.manager.biz.vo.page.PageComponentEditVO;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.util.AssertUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class ComponentPageServiceImpl
implements ComponentPageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentPageServiceImpl.class);
    @Autowired
    private RemoteComponentService remoteComponentService;
    @Autowired
    private RemotePageComponentService remotePageComponentService;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;
    @Autowired
    private PageServiceImpl pageService;

    @Override
    public ComponentPagePreviewVO preview(ComponentPagePreParam param) {
        ComponentPageProcessor pageProcessor = ComponentPageDecider.getProcessor(PageTypeEnum.findByValue((int)param.getPageType()));
        return pageProcessor.preview(param);
    }

    @Override
    public Boolean save(ComponentPageSaveParam saveParam) {
        Long pageId = saveParam.getId();
        if (pageId != null && pageId > 0L) {
            this.pageService.checkPermission(pageId);
        }
        BaiqiPageDto pageDto = new BaiqiPageDto();
        pageDto.setId(pageId);
        pageDto.setPageImg("");
        pageDto.setPageName(saveParam.getPageName());
        pageDto.setPageMd5(saveParam.getMd5());
        pageDto.setPageUrl(saveParam.getPageFileUrl());
        pageDto.setPageStatus(Integer.valueOf(PageStatusEnum.VALID.getValue()));
        pageDto.setPageType(saveParam.getPageType());
        if (pageId == null) {
            pageDto.setCreateName(RequestTool.getAdmin().getName());
        }
        pageDto.setOperatorName(RequestTool.getAdmin().getName());
        pageDto.setStrategyTypeList(saveParam.getStrategyTypeList());
        pageDto.setPageInfo(this.buildJsPlatform(saveParam.getJsPlatform()));
        List<Long> componentIdList = saveParam.fetchComponentIds();
        List componentDtoList = this.remoteComponentService.listBatchByIds(componentIdList);
        HashSet componentIdSet = Sets.newHashSet(componentIdList);
        if (componentDtoList.size() != componentIdSet.size()) {
            throw new QihoManagerException("\u4fdd\u5b58\u53c2\u6570\u9519\u8bef");
        }
        HashMap<Long, ComponentDto> componentMap = new HashMap<Long, ComponentDto>(16);
        for (ComponentDto componentDto : componentDtoList) {
            componentMap.put(componentDto.getId(), componentDto);
        }
        ArrayList pageComponentDtos = Lists.newArrayList();
        int count = 0;
        for (ComponentSimpleParam e : saveParam.getList()) {
            PageComponentDto pageComponentDto = new PageComponentDto();
            pageComponentDto.setConfigParam(e.getConfigParam());
            pageComponentDto.setComponentId(e.getComponentId());
            pageComponentDto.setComponentType(((ComponentDto)componentMap.get(e.getComponentId())).getComponentType());
            pageComponentDto.setSortNum(Integer.valueOf(++count));
            pageComponentDtos.add(pageComponentDto);
        }
        ResultDto resultDto = this.remotePageComponentService.savePageComponent(pageDto, (List)pageComponentDtos);
        if (!resultDto.isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        if (pageId != null) {
            String key = "page:id:" + pageId;
            this.advancedCacheClient.remove(key);
        }
        return true;
    }

    private String buildJsPlatform(Integer jsPlatform) {
        if (jsPlatform == null) {
            return null;
        }
        JSPlatformEnum jsPlatformEnum = JSPlatformEnum.findByType((int)jsPlatform);
        if (jsPlatformEnum == null) {
            return null;
        }
        JSONObject jb = new JSONObject();
        jb.put("jp", (Object)jsPlatform);
        return jb.toJSONString();
    }

    private Integer getJsPlatform(String pageInfo) {
        if (StringUtils.isBlank((String)pageInfo)) {
            return null;
        }
        JSONObject jb = JSON.parseObject((String)pageInfo);
        if (jb == null) {
            return null;
        }
        Object v = jb.get((Object)"jp");
        return v != null ? Integer.valueOf(v.toString()) : null;
    }

    @Override
    public PageComponentEditVO edit(Long pageId) {
        AssertUtil.numericIsPositive((Long)pageId, (String)"\u9875\u9762id\u4e0d\u5408\u6cd5");
        PageComponentDetailDto pageComponentDetail = this.remotePageComponentService.findPageComponentById(pageId);
        if (pageComponentDetail == null) {
            throw new QihoManagerException("\u9875\u9762\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        if (CollectionUtils.isEmpty((Collection)pageComponentDetail.getComponentList())) {
            throw new QihoManagerException("\u8be5\u9875\u9762\u6a21\u677f\u6ca1\u6709\u914d\u7f6e\u7ec4\u4ef6");
        }
        PageComponentEditVO editVO = new PageComponentEditVO();
        editVO.setPageName(pageComponentDetail.getPageName());
        editVO.setJsPlatform(this.getJsPlatform(pageComponentDetail.getPageInfo()));
        editVO.setId(pageComponentDetail.getId());
        List<ComponentSimpleVO> componentList = pageComponentDetail.getComponentList().stream().map(e -> {
            ComponentSimpleVO componentVO = (ComponentSimpleVO)BeanUtils.copy((Object)e, ComponentSimpleVO.class);
            componentVO.setId(e.getComponentId());
            componentVO.setComponentType(e.getComponentType().getNum());
            return componentVO;
        }).collect(Collectors.toList());
        editVO.setComponentList(componentList);
        return editVO;
    }

    @Override
    public Boolean copy(ComponentPageCopyParam param) {
        ResultDto resultDto;
        AssertUtil.numericIsPositive((Long)param.getId(), (String)"\u9875\u9762id\u4e0d\u5408\u6cd5");
        AssertUtil.stringNotBlank((String)param.getPageName(), (String)"\u9875\u9762\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        PageComponentDetailDto pageComponentDetail = this.remotePageComponentService.findPageComponentById(param.getId());
        if (pageComponentDetail == null) {
            throw new QihoManagerException("\u9875\u9762\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        BaiqiPageDto pageDto = (BaiqiPageDto)BeanUtils.copy((Object)pageComponentDetail, BaiqiPageDto.class);
        pageDto.setId(null);
        pageDto.setPageName(param.getPageName());
        pageDto.setOperatorName(RequestTool.getAdmin().getName());
        List pageFormList = this.remotePageComponentService.findPageFormById(param.getId());
        if (CollectionUtils.isNotEmpty((Collection)pageFormList)) {
            pageDto.setStrategyTypeList(pageFormList);
        }
        if (!(resultDto = this.remotePageComponentService.savePageComponent(pageDto, pageComponentDetail.getComponentList())).isSuccess()) {
            throw new QihoManagerException(resultDto.getMsg());
        }
        return true;
    }
}

