/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.biz.service.impl.component;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duiba.wolf.utils.SecurityUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.component.ComponentDto;
import com.qiho.center.api.enums.component.ComponentTypeEnum;
import com.qiho.center.api.remoteservice.component.RemoteComponentService;
import com.qiho.manager.biz.params.component.ComponentParam;
import com.qiho.manager.biz.service.component.ComponentService;
import com.qiho.manager.biz.vo.component.ComponentVO;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.exception.QihoManagerException;
import com.qiho.manager.common.util.AssertUtil;
import com.qiho.manager.common.util.FileIDGenerator;
import com.qiho.manager.common.util.UploadTool;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ComponentServiceImpl
implements ComponentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentServiceImpl.class);
    private static final String CODE_SPLIT = "<split>";
    private static final String PATH_PRE = "component/";
    private static final Joiner LINE_JOINER = Joiner.on((String)"");
    private static final Splitter CODE_SPLITTER = Splitter.on((String)"<split>");
    private static final int DEAULT_CODE_NUM = 3;
    @Value(value="${oss.objectPath}")
    private String ossYunUrl;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;
    @Autowired
    private RemoteComponentService remoteComponentService;

    @Override
    public Boolean createComponent(ComponentParam param) {
        ComponentTypeEnum componentType = ComponentTypeEnum.getByNum((Integer)param.getComponentType());
        AssertUtil.objectNotNull((Object)componentType, (String)"\u7ec4\u4ef6\u7c7b\u578b\u4e0d\u6b63\u786e");
        String code = this.buildCode(param.getHtmlCode(), param.getCssCode(), param.getJsCode());
        String md5 = SecurityUtils.encode2StringByMd5((String)code);
        String codeUrl = this.uploadOss(code);
        String adminName = RequestTool.getAdmin().getName();
        ComponentDto componentDto = new ComponentDto();
        componentDto.setComponentType(componentType);
        componentDto.setComponentName(param.getComponentName());
        componentDto.setCodeUrl(codeUrl);
        componentDto.setCodeMd5(md5);
        componentDto.setConfigParam(param.getConfigParam());
        componentDto.setImage(param.getImage());
        componentDto.setOperator(adminName);
        ResultDto result = this.remoteComponentService.createComponent(componentDto);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        String key = CacheConstantseEnum.COMPONENT_FILE_URL.toString() + ":" + result.getResult();
        this.advancedCacheClient.set(key, (Object)code, CacheConstantseEnum.COMPONENT_FILE_URL.getTime().intValue(), CacheConstantseEnum.COMPONENT_FILE_URL.getTimeUnit());
        return true;
    }

    @Override
    public Boolean updateComponent(ComponentParam param) {
        Long id = param.getId();
        AssertUtil.numericIsPositive((Long)id, (String)"id\u4e0d\u5408\u6cd5");
        ComponentDto componentDto = this.remoteComponentService.findById(id);
        if (componentDto == null) {
            throw new QihoManagerException("\u7ec4\u4ef6\u4e0d\u5b58\u5728");
        }
        if (componentDto.getComponentType() != ComponentTypeEnum.getByNum((Integer)param.getComponentType())) {
            throw new QihoManagerException("\u7ec4\u4ef6\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        String code = this.buildCode(param.getHtmlCode(), param.getCssCode(), param.getJsCode());
        String newMd5 = SecurityUtils.encode2StringByMd5((String)code);
        if (!StringUtils.equalsIgnoreCase((String)newMd5, (String)componentDto.getCodeMd5())) {
            String url = this.uploadOss(code);
            componentDto.setCodeUrl(url);
            componentDto.setCodeMd5(newMd5);
        }
        componentDto.setImage(param.getImage());
        componentDto.setConfigParam(param.getConfigParam());
        componentDto.setComponentName(param.getComponentName());
        componentDto.setOperator(RequestTool.getAdmin().getName());
        ResultDto result = this.remoteComponentService.updateComponent(componentDto);
        if (!result.isSuccess()) {
            throw new QihoManagerException(result.getMsg());
        }
        String key = CacheConstantseEnum.COMPONENT_FILE_URL.toString() + ":" + param.getId();
        this.advancedCacheClient.remove(key);
        this.advancedCacheClient.set(key, (Object)code, CacheConstantseEnum.COMPONENT_FILE_URL.getTime().intValue(), CacheConstantseEnum.COMPONENT_FILE_URL.getTimeUnit());
        return true;
    }

    @Override
    public ComponentVO findById(Long id) {
        AssertUtil.numericIsPositive((Long)id, (String)"\u7ec4\u4ef6id\u4e0d\u5408\u6cd5");
        ComponentDto componentDto = this.remoteComponentService.findById(id);
        AssertUtil.objectNotNull((Object)componentDto, (String)("\u7ec4\u4ef6\u4e0d\u5b58\u5728\uff0c\u7ec4\u4ef6id=" + id));
        String key = CacheConstantseEnum.COMPONENT_FILE_URL.toString() + ":" + id;
        String code = (String)this.advancedCacheClient.get(key);
        ComponentVO componentVO = (ComponentVO)BeanUtils.copy((Object)componentDto, ComponentVO.class);
        if (StringUtils.isNotBlank((String)code)) {
            List codeList = CODE_SPLITTER.splitToList((CharSequence)code);
            if (codeList.size() != 3) {
                throw new QihoManagerException("\u4ee3\u7801\u89e3\u6790\u5f02\u5e38");
            }
            componentVO.setHtmlCode((String)codeList.get(0));
            componentVO.setCssCode((String)codeList.get(1));
            componentVO.setJsCode((String)codeList.get(2));
        } else {
            List<String> codeList = this.downloadCode(componentDto.getCodeUrl(), id);
            componentVO.setHtmlCode(codeList.get(0));
            componentVO.setCssCode(codeList.get(1));
            componentVO.setJsCode(codeList.get(2));
        }
        componentVO.setComponentType(componentDto.getComponentType().getNum());
        componentVO.setGmtModified(DateUtils.getSecondStr((Date)componentDto.getGmtModified()));
        return componentVO;
    }

    @Override
    public List<ComponentVO> findByType(Integer typeNum) {
        AssertUtil.numericIsPositive((Integer)typeNum, (String)"\u65e0\u6548\u7684\u7ec4\u4ef6\u7c7b\u578b");
        ComponentTypeEnum type = ComponentTypeEnum.getByNum((Integer)typeNum);
        AssertUtil.objectNotNull((Object)type, (String)"\u65e0\u6548\u7684\u7ec4\u4ef6\u7c7b\u578b ");
        List componentDtoList = this.remoteComponentService.listByType(type);
        if (CollectionUtils.isEmpty((Collection)componentDtoList)) {
            return Lists.newArrayList();
        }
        List<ComponentVO> list = componentDtoList.stream().map(e -> {
            ComponentVO vo = (ComponentVO)BeanUtils.copy((Object)e, ComponentVO.class);
            vo.setComponentType(e.getComponentType().getNum());
            vo.setGmtModified(DateUtils.getSecondStr((Date)e.getGmtModified()));
            vo.setGmtCreate(DateUtils.getSecondStr((Date)e.getGmtCreate()));
            return vo;
        }).collect(Collectors.toList());
        return list;
    }

    private List<String> downloadCode(String codeUrl, Long componentId) {
        String code;
        AssertUtil.stringNotBlank((String)codeUrl, (String)"\u4ee3\u7801\u6587\u4ef6url\u4e3a\u7a7a");
        try {
            URL url = new URL(codeUrl);
            CharSource charset = Resources.asCharSource((URL)url, (Charset)Charsets.UTF_8);
            ImmutableList lines = charset.readLines();
            code = LINE_JOINER.join((Iterable)lines);
            AssertUtil.stringNotBlank((String)code, (String)"\u83b7\u53d6\u4ee3\u7801\u4e3a\u7a7a");
        }
        catch (IOException e) {
            LOGGER.error("\u4ee3\u7801\u6587\u4ef6\u83b7\u53d6\u5f02\u5e38, codeUrl = [{}]", (Object)codeUrl, (Object)e);
            throw new QihoManagerException("\u4ee3\u7801\u6587\u4ef6\u83b7\u53d6\u5f02\u5e38");
        }
        List codeList = CODE_SPLITTER.splitToList((CharSequence)code);
        if (codeList.size() != 3) {
            throw new QihoManagerException("\u4ee3\u7801\u89e3\u6790\u5f02\u5e38");
        }
        String key = CacheConstantseEnum.COMPONENT_FILE_URL.toString() + ":" + componentId;
        this.advancedCacheClient.set(key, (Object)code, CacheConstantseEnum.COMPONENT_FILE_URL.getTime().intValue(), CacheConstantseEnum.COMPONENT_FILE_URL.getTimeUnit());
        return codeList;
    }

    private String buildCode(String htmlCode, String cssCode, String jsCode) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank((String)htmlCode)) {
            builder.append(new String(SecurityUtils.decodeBase64((String)htmlCode)));
        }
        builder.append(CODE_SPLIT);
        if (StringUtils.isNotBlank((String)cssCode)) {
            builder.append(new String(SecurityUtils.decodeBase64((String)cssCode)));
        }
        builder.append(CODE_SPLIT);
        if (StringUtils.isNotBlank((String)jsCode)) {
            builder.append(new String(SecurityUtils.decodeBase64((String)jsCode)));
        }
        return builder.toString();
    }

    private String uploadOss(String code) {
        if (StringUtils.isBlank((String)code)) {
            throw new QihoManagerException("\u4ee3\u7801\u4e3a\u7a7a");
        }
        String fileName = FileIDGenerator.getRandomString((int)10);
        try {
            File file = File.createTempFile(fileName, ".txt");
            CharSink charSink = Files.asCharSink((File)file, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND});
            charSink.write((CharSequence)code);
            String filePath = PATH_PRE + new DateTime().toString("yyyyMMdd") + "/" + file.getName();
            String url = UploadTool.uploadOssNotCDN((File)file, (String)filePath, (String)"text/plain");
            return "http:" + url;
        }
        catch (Exception e) {
            LOGGER.error("\u4e0a\u4f20\u6587\u4ef6\u9519\u8bef", (Throwable)e);
            throw new QihoManagerException(e.getMessage());
        }
    }
}

